/*
 * Decompiled with CFR 0.152.
 */
package act.view.velocity;

import act.app.App;
import act.util.ActContext;
import act.view.Template;
import act.view.View;
import act.view.velocity.ActResourceLoader;
import act.view.velocity.VelocityTemplate;
import act.view.velocity.VelocityTemplateException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.IO;

public class VelocityView
extends View {
    public static final String ID = "velocity";
    private VelocityEngine engine;
    private ResourceManager resourceManager;

    public String name() {
        return ID;
    }

    protected Template loadTemplate(String resourcePath, ActContext context) {
        try {
            org.apache.velocity.Template template = this.engine.getTemplate(resourcePath);
            return new VelocityTemplate(template);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        catch (VelocityException e) {
            throw new VelocityTemplateException(e);
        }
    }

    protected void init(App app) {
        this.engine = new VelocityEngine();
        this.engine.init(this.conf(app));
    }

    public List<String> loadContent(String template) {
        if (null == this.resourceManager) {
            try {
                Field fieldRi = VelocityEngine.class.getDeclaredField("ri");
                fieldRi.setAccessible(true);
                RuntimeInstance ri = (RuntimeInstance)fieldRi.get(this.engine);
                Field field = RuntimeInstance.class.getDeclaredField("resourceManager");
                field.setAccessible(true);
                this.resourceManager = (ResourceManager)field.get(ri);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
        try {
            Method method = ResourceManagerImpl.class.getDeclaredMethod("getLoaderForResource", String.class);
            method.setAccessible(true);
            ResourceLoader resourceLoader = (ResourceLoader)$.invokeVirtual((Object)this.resourceManager, (Method)method, (Object[])new Object[]{template});
            return IO.readLines((InputStream)resourceLoader.getResourceStream(template));
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
    }

    private Properties conf(App app) {
        Properties p = new Properties();
        p.setProperty("resource.loader", "file,class");
        p.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
        p.setProperty("file.resource.loader.path", this.templateRootDir().getAbsolutePath());
        p.setProperty("file.resource.loader.cache", app.isDev() ? "false" : "true");
        p.setProperty("file.resource.loader.modificationCheckInterval", "0");
        p.setProperty("class.resource.loader.class", ActResourceLoader.class.getName());
        p.setProperty("class.resource.loader.path", this.templateHome());
        return p;
    }
}

