/*
 * Decompiled with CFR 0.152.
 */
package org.actframework.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;

public class Runner {
    private static final Logger LOG = LogManager.get(Runner.class);
    private OutputStream outputStream = System.out;
    private StartedProcess startedProcess;
    private final String mainClass;
    private final String classpath;
    private final File mavenBaseDir;
    private final int jpdaPort;
    private final String jvmArgs;
    private final boolean test;
    private String lombok;

    public Runner(String mainClass, String classpath, File mavenBaseDir, int jpdaPort, String jvmArgs, boolean test, String lombok) {
        this.mainClass = mainClass;
        this.classpath = classpath;
        this.mavenBaseDir = mavenBaseDir;
        this.jpdaPort = test ? 0 : jpdaPort;
        this.jvmArgs = jvmArgs;
        this.test = test;
        this.lombok = lombok;
    }

    public OutputStream getOutput() {
        return this.outputStream;
    }

    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartedProcess getActiveProcess() {
        Runner runner = this;
        synchronized (runner) {
            return this.startedProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProcess(StartedProcess activeProcess) {
        Runner runner = this;
        synchronized (runner) {
            this.startedProcess = activeProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MojoExecutionException {
        Runner runner = this;
        synchronized (runner) {
            try {
                if (this.startedProcess != null) {
                    this.startedProcess.getProcess().destroy();
                    this.startedProcess.getFuture().get();
                }
                this.startedProcess = this.startProcess();
                int exitCode = this.startedProcess.getProcess().waitFor();
                System.out.println("sub process returned with exit code: " + exitCode);
                if (exitCode != 0 && this.test) {
                    throw new MojoExecutionException("End to end test failed");
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LOG.error("Something fishy happenend. Unable to cleanly restart!", new Object[]{e});
                LOG.error("You'll probably need to restart maven?");
            }
        }
    }

    private StartedProcess startProcess() throws IOException {
        ProcessExecutor processExecutor = this.buildProcessExecutor();
        return processExecutor.start();
    }

    private ProcessExecutor buildProcessExecutor() {
        ArrayList<String> commandLine = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        commandLine.add(javaBin);
        if (this.lombok != null) {
            commandLine.add("-javaagent:" + this.lombok + "=ECJ");
        }
        if (this.jpdaPort > 0) {
            LOG.info("Listening for jpda connection at " + this.jpdaPort);
            commandLine.add("-Xdebug");
            String s = System.getProperty("suspend");
            if ($.bool((String)s)) {
                commandLine.add(String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=%s -Djava.awt.headless=true", this.jpdaPort));
            } else {
                commandLine.add(String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%s -Djava.awt.headless=true", this.jpdaPort));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.jvmArgs)) {
            String _jvmArgs = this.jvmArgs;
            if (this.test && !_jvmArgs.contains("-Dprofile=")) {
                _jvmArgs = _jvmArgs + " -Dprofile=test";
            }
            S.List args = S.fastSplit((String)_jvmArgs, (String)" ");
            for (String arg : args) {
                if (!S.notBlank((String)arg)) continue;
                commandLine.add(arg);
            }
        } else if (this.test) {
            commandLine.add("-Dprofile=test");
        }
        if (this.test) {
            commandLine.add("-Dtest.run=true");
        }
        commandLine.add("-cp");
        commandLine.add(this.classpath);
        commandLine.add(this.mainClass);
        return new ProcessExecutor(commandLine).directory(this.mavenBaseDir).destroyOnExit().redirectErrorStream(true).redirectOutput(this.outputStream);
    }
}

