/*
 * Decompiled with CFR 0.152.
 */
package org.actframework.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.actframework.maven.Runner;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.osgl.$;
import org.osgl.util.S;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class ActMojo
extends AbstractMojo {
    @Parameter(property="act.lombok", defaultValue="${app.lombok}", required=false, readonly=true)
    protected String lombok;
    @Parameter(property="act.appEntry", defaultValue="${app.entry}", required=true, readonly=true)
    protected String appEntry;
    @Parameter(property="act.skip", defaultValue="false", required=true)
    protected boolean skip;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="act.jpdaPort", defaultValue="5005", required=true)
    private int jpdaPort;
    @Parameter(property="act.jvmArgs", required=false)
    private String jvmArgs;
    @Parameter(property="act.outputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private String buildOutputDirectory;
    @Parameter(property="act.useDefaultExcludes", defaultValue="true", required=true)
    protected boolean useDefaultExcludes;
    @Parameter(property="act.settleDownMillis", defaultValue="500", required=false)
    private Long settleDownMillis;

    public void execute() throws MojoExecutionException {
        String mavenTestSkip;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on. Will not execute.");
            return;
        }
        if (this.test() && S.notBlank((String)(mavenTestSkip = System.getProperty("maven.test.skip"))) && $.bool((String)mavenTestSkip)) {
            return;
        }
        if ("to.be.Overwritten".equals(this.appEntry) || "ToBeOverwritten".equals(this.appEntry)) {
            this.getLog().info((CharSequence)"Missing AppEntry. Will not execute.");
            return;
        }
        this.checkClasses(this.buildOutputDirectory);
        ArrayList<String> classpathItems = new ArrayList<String>();
        classpathItems.add(this.buildOutputDirectory);
        for (Artifact artifact : this.project.getArtifacts()) {
            classpathItems.add(artifact.getFile().toString());
        }
        this.startRunner(classpathItems);
    }

    private void startRunner(List<String> classpathItems) throws MojoExecutionException {
        Runner machine = this.createRunner(classpathItems);
        machine.start();
    }

    protected Runner createRunner(List<String> classpathItems) {
        this.mergeSystemProperties();
        return new Runner(this.appEntry, StringUtils.join(classpathItems, (String)File.pathSeparator), this.project.getBasedir(), this.jpdaPort, this.jvmArgs, this.test(), this.lombok);
    }

    private void mergeSystemProperties() {
        this._mergeSysProp("test.run");
        this._mergeSysProp("act.test.run");
        this._mergeSysProp("e2e.run");
        this._mergeSysProp("act.e2e.run");
        this._mergeSysProp("profile");
        this._mergeSysProp("act.profile");
    }

    private void _mergeSysProp(String key) {
        String s;
        if (null == this.jvmArgs) {
            this.jvmArgs = "";
        }
        if (S.notBlank((String)(s = System.getProperty(key)))) {
            if (key.startsWith("act.")) {
                key = key.substring(4);
            }
            this.jvmArgs = S.concat((String)this.jvmArgs, (String)" ", (String)"-D", (String)key, (String)"=", (String[])new String[]{s});
        }
    }

    protected boolean test() {
        return false;
    }

    public void checkClasses(String classesDirectory) {
        if (!new File(classesDirectory).exists()) {
            this.getLog().error((CharSequence)("Directory with classes does not exist: " + classesDirectory));
            System.exit(1);
        }
    }
}

