/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.x509.populator;

import java.security.cert.X509Certificate;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.x509.X509AuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class DaoX509AuthoritiesPopulator
implements X509AuthoritiesPopulator,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator == null ? (class$org$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator = DaoX509AuthoritiesPopulator.class$("org.acegisecurity.providers.x509.populator.DaoX509AuthoritiesPopulator")) : class$org$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator));
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private Pattern subjectDNPattern;
    private String subjectDNRegex = "CN=(.*?),";
    private UserDetailsService userDetailsService;
    static /* synthetic */ Class class$org$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"An authenticationDao must be set");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.subjectDNPattern = compiler.compile(this.subjectDNRegex, 32769);
        }
        catch (MalformedPatternException mpe) {
            throw new IllegalArgumentException("Malformed regular expression: " + this.subjectDNRegex);
        }
    }

    public UserDetails getUserDetails(X509Certificate clientCert) throws AuthenticationException {
        Perl5Matcher matcher = new Perl5Matcher();
        String subjectDN = clientCert.getSubjectDN().getName();
        if (!matcher.contains(subjectDN, this.subjectDNPattern)) {
            throw new BadCredentialsException(this.messages.getMessage("DaoX509AuthoritiesPopulator.noMatching", new Object[]{subjectDN}, "No matching pattern was found in subjectDN: {0}"));
        }
        MatchResult match = matcher.getMatch();
        if (match.groups() != 2) {
            throw new IllegalArgumentException("Regular expression must contain a single group ");
        }
        String userName = match.group(1);
        UserDetails user = this.userDetailsService.loadUserByUsername(userName);
        if (user == null) {
            throw new AuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        }
        return user;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setSubjectDNRegex(String subjectDNRegex) {
        this.subjectDNRegex = subjectDNRegex;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

