/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.webapp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteminderAuthenticationProcessingFilter
extends AuthenticationProcessingFilter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilter == null ? (class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilter = SiteminderAuthenticationProcessingFilter.class$("org.acegisecurity.ui.webapp.SiteminderAuthenticationProcessingFilter")) : class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilter));
    private String formPasswordParameterKey = null;
    private String formUsernameParameterKey = null;
    private String siteminderPasswordHeaderKey = null;
    private String siteminderUsernameHeaderKey = null;
    static /* synthetic */ Class class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilter;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String username = null;
        String password = null;
        if (this.siteminderUsernameHeaderKey != null && this.siteminderUsernameHeaderKey.length() > 0 && this.siteminderPasswordHeaderKey != null && this.siteminderPasswordHeaderKey.length() > 0) {
            username = request.getHeader(this.siteminderUsernameHeaderKey);
            password = request.getHeader(this.siteminderPasswordHeaderKey);
        }
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Siteminder headers not found for authentication, so trying to use form values");
            }
            username = this.formUsernameParameterKey != null && this.formUsernameParameterKey.length() > 0 ? request.getParameter(this.formUsernameParameterKey) : request.getParameter("j_username");
            password = this.obtainPassword(request);
        }
        username = username != null ? username.toUpperCase() : "";
        password = password != null ? password.toUpperCase() : "";
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(username, password);
        this.setDetails(request, authRequest);
        request.getSession().setAttribute("ACEGI_SECURITY_LAST_USERNAME", (Object)username);
        return this.getAuthenticationManager().authenticate(authRequest);
    }

    public String getFormPasswordParameterKey() {
        return this.formPasswordParameterKey;
    }

    public String getFormUsernameParameterKey() {
        return this.formUsernameParameterKey;
    }

    public String getSiteminderPasswordHeaderKey() {
        return this.siteminderPasswordHeaderKey;
    }

    public String getSiteminderUsernameHeaderKey() {
        return this.siteminderUsernameHeaderKey;
    }

    protected String obtainPassword(HttpServletRequest request) {
        if (this.formPasswordParameterKey != null && this.formPasswordParameterKey.length() > 0) {
            return request.getParameter(this.formPasswordParameterKey);
        }
        return request.getParameter("j_password");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean bAttemptAuthentication;
        Authentication auth;
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        boolean bAuthenticated = false;
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("ACEGI_SECURITY_CONTEXT");
        if (context != null && (auth = context.getAuthentication()) != null && auth instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
            bAuthenticated = token.isAuthenticated();
        }
        boolean bl = bAttemptAuthentication = uri.endsWith(request.getContextPath() + this.getFilterProcessesUrl()) || this.getDefaultTargetUrl() != null && uri.endsWith(this.getDefaultTargetUrl()) && !bAuthenticated;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication attempted for the following URI ==> " + uri + " is " + bAttemptAuthentication));
        }
        return bAttemptAuthentication;
    }

    public void setFormPasswordParameterKey(String key) {
        this.formPasswordParameterKey = key;
    }

    public void setFormUsernameParameterKey(String key) {
        this.formUsernameParameterKey = key;
    }

    public void setSiteminderPasswordHeaderKey(String key) {
        this.siteminderPasswordHeaderKey = key;
    }

    public void setSiteminderUsernameHeaderKey(String key) {
        this.siteminderUsernameHeaderKey = key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

