/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.util.Iterator;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator == null ? (class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator = BindAuthenticator.class$("org.acegisecurity.providers.ldap.authenticator.BindAuthenticator")) : class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator));
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$authenticator$BindAuthenticator;

    public BindAuthenticator(InitialDirContextFactory initialDirContextFactory) {
        super(initialDirContextFactory);
    }

    public LdapUserDetails authenticate(String username, String password) {
        LdapUserDetails user = null;
        Iterator dns = this.getUserDns(username).iterator();
        while (dns.hasNext() && user == null) {
            user = this.bindWithDn((String)dns.next(), username, password);
        }
        if (user == null && this.getUserSearch() != null) {
            LdapUserDetails userFromSearch = this.getUserSearch().searchForUser(username);
            user = this.bindWithDn(userFromSearch.getDn(), username, password);
        }
        if (user == null) {
            throw new BadCredentialsException(this.messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    private LdapUserDetails bindWithDn(String userDn, String username, String password) {
        LdapTemplate template = new LdapTemplate(this.getInitialDirContextFactory(), userDn, password);
        try {
            LdapUserDetailsImpl.Essence user = (LdapUserDetailsImpl.Essence)template.retrieveEntry(userDn, this.getUserDetailsMapper(), this.getUserAttributes());
            user.setUsername(username);
            return user.createUserDetails();
        }
        catch (BadCredentialsException e) {
            this.handleBindException(userDn, username, e.getCause());
            return null;
        }
    }

    void handleBindException(String userDn, String username, Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to bind as " + userDn + ": " + cause));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

