/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LockStepResource
extends AbstractDescribableImpl<LockStepResource>
implements Serializable {
    @CheckForNull
    public String resource = null;
    @CheckForNull
    public String label = null;
    public int quantity = 0;
    private static final long serialVersionUID = 1L;

    LockStepResource(String resource, String label, int quantity) {
        this.resource = resource;
        this.label = label;
        this.quantity = quantity;
    }

    @DataBoundConstructor
    public LockStepResource(String resource) {
        if (resource != null && !resource.isEmpty()) {
            this.resource = resource;
        }
    }

    @DataBoundSetter
    public void setLabel(String label) {
        if (label != null && !label.isEmpty()) {
            this.label = label;
        }
    }

    @DataBoundSetter
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String toString() {
        return LockStepResource.toString(this.resource, this.label, this.quantity);
    }

    public static String toString(String resource, String label, int quantity) {
        if (label != null) {
            if (quantity > 0) {
                return "Label: " + label + ", Quantity: " + quantity;
            }
            return "Label: " + label;
        }
        if (resource != null) {
            return resource;
        }
        return "[no resource/label specified - probably a bug]";
    }

    public void validate() throws Exception {
        LockStepResource.validate(this.resource, this.label, this.quantity);
    }

    public static void validate(String resource, String label, int quantity) throws Exception {
        if (label != null && !label.isEmpty() && resource != null && !resource.isEmpty()) {
            throw new IllegalArgumentException("Label and resource name cannot be specified simultaneously.");
        }
        if (label != null && !LockableResourcesManager.get().isValidLabel(label).booleanValue()) {
            throw new IllegalArgumentException("The label does not exist: " + label);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockStepResource> {
        public String getDisplayName() {
            return "Resource";
        }

        public AutoCompletionCandidates doAutoCompleteResource(@QueryParameter String value) {
            return RequiredResourcesProperty.DescriptorImpl.doAutoCompleteResourceNames(value);
        }

        public static FormValidation doCheckLabel(@QueryParameter String value, @QueryParameter String resource) {
            String resourceLabel = Util.fixEmpty((String)value);
            String resourceName = Util.fixEmpty((String)resource);
            if (resourceLabel != null && resourceName != null) {
                return FormValidation.error((String)"Label and resource name cannot be specified simultaneously.");
            }
            if (resourceLabel == null && resourceName == null) {
                return FormValidation.error((String)"Either label or resource name must be specified.");
            }
            if (resourceLabel != null && !LockableResourcesManager.get().isValidLabel(resourceLabel).booleanValue()) {
                return FormValidation.error((String)("The label does not exist: " + resourceLabel));
            }
            return FormValidation.ok();
        }

        public static FormValidation doCheckResource(@QueryParameter String value, @QueryParameter String label) {
            return DescriptorImpl.doCheckLabel(label, value);
        }
    }
}

