/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class LockStepExecution
extends AbstractStepExecutionImpl {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    @Inject(optional=true)
    private LockStep step;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FlowNode node;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        this.step.validate();
        this.node.addAction((Action)new PauseAction("Lock"));
        this.listener.getLogger().println("Trying to acquire lock on [" + this.step + "]");
        ArrayList<LockableResourcesStruct> resourceHolderList = new ArrayList<LockableResourcesStruct>();
        for (LockStepResource lockStepResource : this.step.getResources()) {
            ArrayList<String> resources = new ArrayList<String>();
            if (lockStepResource.resource != null) {
                if (LockableResourcesManager.get().createResource(lockStepResource.resource)) {
                    this.listener.getLogger().println("Resource [" + lockStepResource + "] did not exist. Created.");
                }
                resources.add(lockStepResource.resource);
            }
            resourceHolderList.add(new LockableResourcesStruct(resources, lockStepResource.label, lockStepResource.quantity));
        }
        Set<LockableResource> available = LockableResourcesManager.get().checkResourcesAvailability(resourceHolderList, this.listener.getLogger(), null);
        if (available == null || !LockableResourcesManager.get().lock(available, this.run, this.getContext(), this.step.toString(), this.step.variable, this.step.inversePrecedence)) {
            LockableResource lockableResource = LockableResourcesManager.get().fromName(this.step.resource);
            if (lockableResource != null && lockableResource.getBuildName() != null) {
                this.listener.getLogger().println("[" + this.step + "] is locked by " + lockableResource.getBuildName() + ", waiting...");
            } else {
                this.listener.getLogger().println("[" + this.step + "] is locked, waiting...");
            }
            LockableResourcesManager.get().queueContext(this.getContext(), resourceHolderList, this.step.toString(), this.step.variable);
        }
        return false;
    }

    public static void proceed(final List<String> resourcenames, StepContext context, String resourceDescription, final String variable, boolean inversePrecedence) {
        Run r = null;
        FlowNode node = null;
        try {
            r = (Run)context.get(Run.class);
            node = (FlowNode)context.get(FlowNode.class);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock acquired on [" + resourceDescription + "]");
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        LOGGER.finest("Lock acquired on [" + resourceDescription + "] by " + r.getExternalizableId());
        try {
            PauseAction.endCurrentPause((FlowNode)node);
            BodyInvoker bodyInvoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(resourcenames, resourceDescription, inversePrecedence));
            if (variable != null && variable.length() > 0) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new EnvironmentExpander(){

                    public void expand(EnvVars env) throws IOException, InterruptedException {
                        String resources = COMMA_JOINER.join((Iterable)resourcenames);
                        LOGGER.finest("Setting [" + variable + "] to [" + resources + "] for the duration of the block");
                        env.override(variable, resources);
                    }
                }));
            }
            bodyInvoker.start();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(Throwable cause) throws Exception {
        boolean cleaned = LockableResourcesManager.get().unqueueContext(this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource witing list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private final List<String> resourceNames;
        private final String resourceDescription;
        private final boolean inversePrecedence;
        private static final long serialVersionUID = 1L;

        Callback(List<String> resourceNames, String resourceDescription, boolean inversePrecedence) {
            this.resourceNames = resourceNames;
            this.resourceDescription = resourceDescription;
            this.inversePrecedence = inversePrecedence;
        }

        protected void finished(StepContext context) throws Exception {
            LockableResourcesManager.get().unlockNames(this.resourceNames, (Run)context.get(Run.class), this.inversePrecedence);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock released on resource [" + this.resourceDescription + "]");
            LOGGER.finest("Lock released on [" + this.resourceDescription + "]");
        }
    }
}

