/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesCandidatesStruct;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.QueuedContextStruct;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class LockableResourcesManager
extends GlobalConfiguration {
    @Deprecated
    private transient int defaultPriority;
    @Deprecated
    private transient String priorityParameterName;
    private List<LockableResource> resources;
    private List<QueuedContextStruct> queuedContexts = new ArrayList<QueuedContextStruct>();
    private static final Logger LOGGER = Logger.getLogger(LockableResourcesManager.class.getName());

    public LockableResourcesManager() {
        this.resources = new ArrayList<LockableResource>();
        this.load();
    }

    public List<LockableResource> getResources() {
        return this.resources;
    }

    public synchronized List<LockableResource> getDeclaredResources() {
        ArrayList<LockableResource> declaredResources = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            if (r.isEphemeral()) continue;
            declaredResources.add(r);
        }
        return declaredResources;
    }

    @DataBoundSetter
    public synchronized void setDeclaredResources(List<LockableResource> declaredResources) {
        HashMap<String, LockableResource> lockedResources = new HashMap<String, LockableResource>();
        for (LockableResource r : this.resources) {
            if (!r.isLocked()) continue;
            lockedResources.put(r.getName(), r);
        }
        ArrayList<LockableResource> mergedResources = new ArrayList<LockableResource>();
        HashSet<String> addedLocks = new HashSet<String>();
        for (LockableResource r : declaredResources) {
            if (!addedLocks.add(r.getName())) continue;
            LockableResource locked = (LockableResource)lockedResources.remove(r.getName());
            if (locked != null) {
                locked.setDescription(r.getDescription());
                locked.setLabels(r.getLabels());
                locked.setEphemeral(false);
                mergedResources.add(locked);
                continue;
            }
            mergedResources.add(r);
        }
        for (LockableResource r : lockedResources.values()) {
            r.setDescription("");
            r.setLabels("");
            r.setEphemeral(true);
            mergedResources.add(r);
        }
        this.resources = mergedResources;
    }

    public List<LockableResource> getResourcesFromProject(String fullName) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            String rName = r.getQueueItemProject();
            if (rName == null || !rName.equals(fullName)) continue;
            matching.add(r);
        }
        return matching;
    }

    public List<LockableResource> getResourcesFromBuild(Run<?, ?> build) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            Run<?, ?> rBuild = r.getBuild();
            if (rBuild == null || rBuild != build) continue;
            matching.add(r);
        }
        return matching;
    }

    public Boolean isValidLabel(String label) {
        return this.getAllLabels().contains(label);
    }

    public Set<String> getAllLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (LockableResource r : this.resources) {
            String rl = r.getLabels();
            if (rl == null || "".equals(rl)) continue;
            labels.addAll(Arrays.asList(rl.split("\\s+")));
        }
        return labels;
    }

    public int getFreeResourceAmount(String label) {
        int free = 0;
        for (LockableResource r : this.resources) {
            if (r.isLocked() || r.isQueued() || r.isReserved() || !Arrays.asList(r.getLabels().split("\\s+")).contains(label)) continue;
            ++free;
        }
        return free;
    }

    public List<LockableResource> getResourcesWithLabel(String label, Map<String, Object> params) {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            if (!r.isValidLabel(label, params)) continue;
            found.add(r);
        }
        return found;
    }

    @Nonnull
    public List<LockableResource> getResourcesMatchingScript(@Nonnull SecureGroovyScript script, @CheckForNull Map<String, Object> params) throws ExecutionException {
        ArrayList<LockableResource> found = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            if (!r.scriptMatches(script, params)) continue;
            found.add(r);
        }
        return found;
    }

    public LockableResource fromName(String resourceName) {
        if (resourceName != null) {
            for (LockableResource r : this.resources) {
                if (!resourceName.equals(r.getName())) continue;
                return r;
            }
        }
        return null;
    }

    public synchronized boolean queue(List<LockableResource> resources, long queueItemId, String queueProjectName) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isQueued(queueItemId) && !r.isLocked()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setQueued(queueItemId, queueProjectName);
        }
        return true;
    }

    @Deprecated
    @CheckForNull
    public synchronized List<LockableResource> queue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) {
        try {
            return this.tryQueue(requiredResources, queueItemId, queueItemProject, number, params, log);
        }
        catch (ExecutionException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                String itemName = queueItemProject + " (id=" + queueItemId + ")";
                LOGGER.log(Level.WARNING, "Failed to queue item " + itemName, ex.getCause() != null ? ex.getCause() : ex);
            }
            return null;
        }
    }

    @CheckForNull
    public synchronized List<LockableResource> tryQueue(LockableResourcesStruct requiredResources, long queueItemId, String queueItemProject, int number, Map<String, Object> params, Logger log) throws ExecutionException {
        int required_amount;
        ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
        if (!this.checkCurrentResourcesStatus(selected, queueItemProject, queueItemId, log)) {
            log.log(Level.FINEST, "{0} has another build waiting resources. Waiting for it to proceed first.", new Object[]{queueItemProject});
            return null;
        }
        boolean candidatesByScript = false;
        List<Object> candidates = new ArrayList();
        SecureGroovyScript systemGroovyScript = requiredResources.getResourceMatchScript();
        if (requiredResources.label != null && requiredResources.label.isEmpty() && systemGroovyScript == null) {
            candidates = requiredResources.required;
        } else if (systemGroovyScript == null) {
            candidates = this.getResourcesWithLabel(requiredResources.label, params);
        } else {
            candidates = this.getResourcesMatchingScript(systemGroovyScript, params);
            candidatesByScript = true;
        }
        for (LockableResource lockableResource : candidates) {
            if (number != 0 && selected.size() >= number) break;
            if (lockableResource.isReserved() || lockableResource.isLocked() || lockableResource.isQueued()) continue;
            selected.add(lockableResource);
        }
        if (candidatesByScript && candidates.isEmpty()) {
            required_amount = 0;
        } else {
            int n = required_amount = number == 0 ? candidates.size() : number;
        }
        if (selected.size() != required_amount) {
            log.log(Level.FINEST, "{0} found {1} resource(s) to queue.Waiting for correct amount: {2}.", new Object[]{queueItemProject, selected.size(), required_amount});
            for (LockableResource x : this.resources) {
                if (x.getQueueItemProject() == null || !x.getQueueItemProject().equals(queueItemProject)) continue;
                x.unqueue();
            }
            return null;
        }
        for (LockableResource rsc : selected) {
            rsc.setQueued(queueItemId, queueItemProject);
        }
        return selected;
    }

    private boolean checkCurrentResourcesStatus(List<LockableResource> selected, String project, long taskId, Logger log) {
        for (LockableResource r : this.resources) {
            String rProject = r.getQueueItemProject();
            if (rProject == null || !rProject.equals(project)) continue;
            if (r.isQueuedByTask(taskId)) {
                selected.add(r);
                continue;
            }
            log.log(Level.FINEST, "{0} has another build that already queued resource {1}. Continue queueing.", new Object[]{project, r});
            return false;
        }
        return true;
    }

    public synchronized boolean lock(Set<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context) {
        return this.lock(resources, build, context, null, null, false);
    }

    public synchronized boolean lock(Set<LockableResource> resources, Run<?, ?> build, @Nullable StepContext context, @Nullable String logmessage, String variable, boolean inversePrecedence) {
        boolean needToWait = false;
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked()) continue;
            needToWait = true;
            break;
        }
        if (!needToWait) {
            for (LockableResource r : resources) {
                r.unqueue();
                r.setBuild(build);
            }
            if (context != null) {
                ArrayList<String> resourceNames = new ArrayList<String>();
                for (LockableResource resource : resources) {
                    resourceNames.add(resource.getName());
                }
                LockStepExecution.proceed(resourceNames, context, logmessage, variable, inversePrecedence);
            }
            this.save();
        }
        return !needToWait;
    }

    private synchronized void freeResources(List<String> unlockResourceNames, @Nullable Run<?, ?> build) {
        for (String unlockResourceName : unlockResourceNames) {
            Iterator<LockableResource> resourceIterator = this.resources.iterator();
            while (resourceIterator.hasNext()) {
                LockableResource resource = resourceIterator.next();
                if (resource == null || resource.getName() == null || !resource.getName().equals(unlockResourceName) || build != null && (resource.getBuild() == null || !build.getExternalizableId().equals(resource.getBuild().getExternalizableId()))) continue;
                resource.unqueue();
                resource.setBuild(null);
                if (!resource.isEphemeral()) continue;
                resourceIterator.remove();
            }
        }
    }

    public synchronized void unlock(List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build) {
        this.unlock(resourcesToUnLock, build, null, false);
    }

    public synchronized void unlock(@Nullable List<LockableResource> resourcesToUnLock, @Nullable Run<?, ?> build, String requiredVar, boolean inversePrecedence) {
        ArrayList<String> resourceNamesToUnLock = new ArrayList<String>();
        if (resourcesToUnLock != null) {
            for (LockableResource r : resourcesToUnLock) {
                resourceNamesToUnLock.add(r.getName());
            }
        }
        this.unlockNames(resourceNamesToUnLock, build, requiredVar, inversePrecedence);
    }

    public synchronized void unlockNames(@Nullable List<String> resourceNamesToUnLock, @Nullable Run<?, ?> build, String requiredVar, boolean inversePrecedence) {
        if (resourceNamesToUnLock == null || resourceNamesToUnLock.isEmpty()) {
            return;
        }
        ArrayList<String> remainingResourceNamesToUnLock = new ArrayList<String>(resourceNamesToUnLock);
        QueuedContextStruct nextContext = null;
        while (!remainingResourceNamesToUnLock.isEmpty()) {
            Set<LockableResource> requiredResourceForNextContext = null;
            if ((nextContext = this.getNextQueuedContext(remainingResourceNamesToUnLock, inversePrecedence, nextContext)) == null) {
                this.freeResources(remainingResourceNamesToUnLock, build);
                this.save();
                return;
            }
            requiredResourceForNextContext = this.checkResourcesAvailability(nextContext.getResources(), null, remainingResourceNamesToUnLock);
            boolean needToWait = false;
            for (LockableResource lockableResource : requiredResourceForNextContext) {
                if (remainingResourceNamesToUnLock.contains(lockableResource.getName()) || !lockableResource.isReserved() && !lockableResource.isLocked()) continue;
                needToWait = true;
                break;
            }
            if (needToWait) continue;
            this.unqueueContext(nextContext.getContext());
            ArrayList<String> resourceNamesToLock = new ArrayList<String>();
            for (LockableResource requiredResource3 : requiredResourceForNextContext) {
                try {
                    requiredResource3.setBuild((Run)nextContext.getContext().get(Run.class));
                    resourceNamesToLock.add(requiredResource3.getName());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Skipping queued context for lock. Can not get the Run object from the context to proceed with lock, this could be a legitimate status if the build waiting for the lock was deleted or hard killed. More information at Level.FINE if debug is needed.");
                    LOGGER.log(Level.FINE, "Can not get the Run object from the context to proceed with lock", e);
                    this.unlockNames(remainingResourceNamesToUnLock, build, requiredVar, inversePrecedence);
                    return;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String resourceNameToUnlock : remainingResourceNamesToUnLock) {
                boolean resourceStillNeeded = false;
                for (LockableResource requiredResource4 : requiredResourceForNextContext) {
                    if (resourceNameToUnlock == null || !resourceNameToUnlock.equals(requiredResource4.getName())) continue;
                    resourceStillNeeded = true;
                    break;
                }
                if (resourceStillNeeded) continue;
                arrayList.add(resourceNameToUnlock);
            }
            remainingResourceNamesToUnLock.retainAll(arrayList);
            LockStepExecution.proceed(resourceNamesToLock, nextContext.getContext(), nextContext.getResourceDescription(), requiredVar, inversePrecedence);
        }
        this.save();
    }

    @CheckForNull
    private QueuedContextStruct getNextQueuedContext(List<String> resourceNamesToUnLock, boolean inversePrecedence, QueuedContextStruct from) {
        int fromIndex;
        QueuedContextStruct newestEntry = null;
        int n = fromIndex = from != null ? this.queuedContexts.indexOf(from) + 1 : 0;
        if (!inversePrecedence) {
            for (int i = fromIndex; i < this.queuedContexts.size(); ++i) {
                QueuedContextStruct entry = this.queuedContexts.get(i);
                if (this.checkResourcesAvailability(entry.getResources(), null, resourceNamesToUnLock) == null) continue;
                return entry;
            }
        } else {
            long newest = 0L;
            ArrayList<QueuedContextStruct> orphan = new ArrayList<QueuedContextStruct>();
            for (int i = fromIndex; i < this.queuedContexts.size(); ++i) {
                QueuedContextStruct entry = this.queuedContexts.get(i);
                if (this.checkResourcesAvailability(entry.getResources(), null, resourceNamesToUnLock) == null) continue;
                try {
                    Run run = (Run)entry.getContext().get(Run.class);
                    if (run == null || run.getStartTimeInMillis() <= newest) continue;
                    newest = run.getStartTimeInMillis();
                    newestEntry = entry;
                    continue;
                }
                catch (IOException | InterruptedException e) {
                    orphan.add(entry);
                }
            }
            if (!orphan.isEmpty()) {
                this.queuedContexts.removeAll(orphan);
            }
        }
        return newestEntry;
    }

    public synchronized boolean createResource(String name) {
        LockableResource existent;
        if (name != null && (existent = this.fromName(name)) == null) {
            LockableResource resource = new LockableResource(name);
            resource.setEphemeral(true);
            this.getResources().add(resource);
            this.save();
            return true;
        }
        return false;
    }

    public synchronized boolean createResourceWithLabel(String name, String label) {
        LockableResource existent;
        if (name != null && label != null && (existent = this.fromName(name)) == null) {
            this.getResources().add(new LockableResource(name, "", label, null));
            this.save();
            return true;
        }
        return false;
    }

    public synchronized boolean reserve(List<LockableResource> resources, String userName) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked() && !r.isQueued()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setReservedBy(userName);
        }
        this.save();
        return true;
    }

    private void unreserveResources(@Nonnull List<LockableResource> resources) {
        for (LockableResource l : resources) {
            l.unReserve();
        }
        this.save();
    }

    public synchronized void unreserve(List<LockableResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        ArrayList<String> resourceNamesToUnreserve = new ArrayList<String>();
        for (LockableResource r : resources) {
            resourceNamesToUnreserve.add(r.getName());
        }
        Set<LockableResource> requiredResourceForNextContext = null;
        QueuedContextStruct nextContext = this.getNextQueuedContext(resourceNamesToUnreserve, false, null);
        if (nextContext == null) {
            LOGGER.log(Level.FINER, "No context queued for resources " + StringUtils.join(resourceNamesToUnreserve, (String)", ") + " so unreserving and proceeding.");
            this.unreserveResources(resources);
            return;
        }
        PrintStream nextContextLogger = null;
        try {
            TaskListener nextContextTaskListener = (TaskListener)nextContext.getContext().get(TaskListener.class);
            if (nextContextTaskListener != null) {
                nextContextLogger = nextContextTaskListener.getLogger();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINE, "Could not get logger for next context: " + e, e);
        }
        requiredResourceForNextContext = this.checkResourcesAvailability(nextContext.getResources(), nextContextLogger, resourceNamesToUnreserve);
        this.queuedContexts.remove(nextContext);
        boolean needToWait = false;
        for (LockableResource requiredResource : requiredResourceForNextContext) {
            if (resourceNamesToUnreserve.contains(requiredResource.getName()) || !requiredResource.isReserved() && !requiredResource.isLocked()) continue;
            needToWait = true;
            break;
        }
        if (needToWait) {
            this.unreserveResources(resources);
            return;
        }
        this.unreserveResources(resources);
        ArrayList<String> resourceNamesToLock = new ArrayList<String>();
        for (LockableResource requiredResource : requiredResourceForNextContext) {
            try {
                requiredResource.setBuild((Run)nextContext.getContext().get(Run.class));
                resourceNamesToLock.add(requiredResource.getName());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Skipping queued context for lock. Can not get the Run object from the context to proceed with lock, this could be a legitimate status if the build waiting for the lock was deleted or hard killed. More information at Level.FINE if debug is needed.");
                LOGGER.log(Level.FINE, "Can not get the Run object from the context to proceed with lock", e);
                return;
            }
        }
        LockStepExecution.proceed(resourceNamesToLock, nextContext.getContext(), nextContext.getResourceDescription(), null, false);
        this.save();
    }

    public String getDisplayName() {
        return "External Resources";
    }

    public synchronized void reset(List<LockableResource> resources) {
        for (LockableResource r : resources) {
            r.reset();
        }
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            req.bindJSON((Object)this, json);
            bc.commit();
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Exception occurred while committing bulkchange operation.", exception);
            return false;
        }
        return true;
    }

    public synchronized Set<LockableResource> checkResourcesAvailability(List<LockableResourcesStruct> requiredResourcesList, @Nullable PrintStream logger, @Nullable List<String> lockedResourcesAboutToBeUnlocked) {
        ArrayList<LockableResourcesCandidatesStruct> requiredResourcesCandidatesList = new ArrayList<LockableResourcesCandidatesStruct>();
        for (LockableResourcesStruct lockableResourcesStruct : requiredResourcesList) {
            int requiredAmount = 0;
            ArrayList<LockableResource> candidates = new ArrayList<LockableResource>();
            if (lockableResourcesStruct.label != null && lockableResourcesStruct.label.isEmpty()) {
                candidates.addAll(lockableResourcesStruct.required);
            } else {
                candidates.addAll(this.getResourcesWithLabel(lockableResourcesStruct.label, null));
                if (lockableResourcesStruct.requiredNumber != null) {
                    try {
                        requiredAmount = Integer.parseInt(lockableResourcesStruct.requiredNumber);
                    }
                    catch (NumberFormatException e) {
                        requiredAmount = 0;
                    }
                }
            }
            if (requiredAmount == 0) {
                requiredAmount = candidates.size();
            }
            requiredResourcesCandidatesList.add(new LockableResourcesCandidatesStruct(candidates, requiredAmount));
        }
        int totalSelected = 0;
        for (LockableResourcesCandidatesStruct requiredResources : requiredResourcesCandidatesList) {
            ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
            if (lockedResourcesAboutToBeUnlocked != null) {
                for (LockableResource candidate : requiredResources.candidates) {
                    if (selected.size() >= requiredResources.requiredAmount) break;
                    if (!lockedResourcesAboutToBeUnlocked.contains(candidate.getName())) continue;
                    selected.add(candidate);
                }
            }
            totalSelected += selected.size();
            requiredResources.selected = selected;
        }
        if (lockedResourcesAboutToBeUnlocked != null && totalSelected == 0) {
            return null;
        }
        HashSet<LockableResource> hashSet = new HashSet<LockableResource>();
        for (LockableResourcesCandidatesStruct requiredResources : requiredResourcesCandidatesList) {
            List<LockableResource> candidates = requiredResources.candidates;
            List<LockableResource> selected = requiredResources.selected;
            int requiredAmount = requiredResources.requiredAmount;
            ArrayList<LockableResource> alreadySelectedCandidates = new ArrayList<LockableResource>(candidates);
            alreadySelectedCandidates.retainAll(hashSet);
            for (LockableResource rs : alreadySelectedCandidates) {
                if (selected.size() >= requiredAmount) break;
                if (rs.isReserved() || rs.isLocked()) continue;
                selected.add(rs);
            }
            candidates.removeAll(alreadySelectedCandidates);
            for (LockableResource rs : candidates) {
                if (selected.size() >= requiredAmount) break;
                if (rs.isReserved() || rs.isLocked()) continue;
                selected.add(rs);
            }
            if (selected.size() < requiredAmount) {
                if (logger != null) {
                    logger.println("Found " + selected.size() + " available resource(s). Waiting for correct amount: " + requiredAmount + ".");
                }
                return null;
            }
            hashSet.addAll(selected);
        }
        return hashSet;
    }

    public synchronized void queueContext(StepContext context, List<LockableResourcesStruct> requiredResources, String resourceDescription) {
        for (QueuedContextStruct entry : this.queuedContexts) {
            if (entry.getContext() != context) continue;
            return;
        }
        this.queuedContexts.add(new QueuedContextStruct(context, requiredResources, resourceDescription));
        this.save();
    }

    public synchronized boolean unqueueContext(StepContext context) {
        ListIterator<QueuedContextStruct> iter = this.queuedContexts.listIterator();
        while (iter.hasNext()) {
            if (((QueuedContextStruct)iter.next()).getContext() != context) continue;
            iter.remove();
            this.save();
            return true;
        }
        return false;
    }

    public static LockableResourcesManager get() {
        return (LockableResourcesManager)Jenkins.getInstance().getDescriptorOrDie(LockableResourcesManager.class);
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
    }
}

