/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LockStep
extends AbstractStepImpl
implements Serializable {
    @CheckForNull
    public String resource = null;
    @CheckForNull
    public String label = null;
    public int quantity = 0;
    @CheckForNull
    public String variable = null;
    public boolean inversePrecedence = false;
    @CheckForNull
    public List<LockStepResource> extra = null;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LockStep(String resource) {
        if (resource != null && !resource.isEmpty()) {
            this.resource = resource;
        }
    }

    @DataBoundSetter
    public void setInversePrecedence(boolean inversePrecedence) {
        this.inversePrecedence = inversePrecedence;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        if (label != null && !label.isEmpty()) {
            this.label = label;
        }
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        if (variable != null && !variable.isEmpty()) {
            this.variable = variable;
        }
    }

    @DataBoundSetter
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @DataBoundSetter
    public void setExtra(List<LockStepResource> extra) {
        this.extra = extra;
    }

    public String toString() {
        if (this.extra != null && !this.extra.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (LockStepResource resource : this.getResources()) {
                builder.append("{" + resource.toString() + "},");
            }
            return builder.toString();
        }
        return LockStepResource.toString(this.resource, this.label, this.quantity);
    }

    public void validate() throws Exception {
        LockStepResource.validate(this.resource, this.label, this.quantity);
    }

    public List<LockStepResource> getResources() {
        ArrayList<LockStepResource> resources = new ArrayList<LockStepResource>();
        resources.add(new LockStepResource(this.resource, this.label, this.quantity));
        if (this.extra != null) {
            resources.addAll(this.extra);
        }
        return resources;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(LockStepExecution.class);
        }

        public String getFunctionName() {
            return "lock";
        }

        public String getDisplayName() {
            return "Lock shared resource";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public AutoCompletionCandidates doAutoCompleteResource(@QueryParameter String value) {
            return RequiredResourcesProperty.DescriptorImpl.doAutoCompleteResourceNames(value);
        }

        public static FormValidation doCheckLabel(@QueryParameter String value, @QueryParameter String resource) {
            return LockStepResource.DescriptorImpl.doCheckLabel(value, resource);
        }

        public static FormValidation doCheckResource(@QueryParameter String value, @QueryParameter String label) {
            return LockStepResource.DescriptorImpl.doCheckLabel(label, value);
        }
    }
}

