/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.io.Serializable;
import org.jenkins.plugins.lockableresources.LockStepExecution;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LockStep
extends AbstractStepImpl
implements Serializable {
    @CheckForNull
    public String resource = null;
    @CheckForNull
    public String label = null;
    public int quantity = 0;
    @CheckForNull
    public String variable = null;
    public boolean inversePrecedence = false;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LockStep(String resource) {
        if (resource != null && !resource.isEmpty()) {
            this.resource = resource;
        }
    }

    @DataBoundSetter
    public void setInversePrecedence(boolean inversePrecedence) {
        this.inversePrecedence = inversePrecedence;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        if (label != null && !label.isEmpty()) {
            this.label = label;
        }
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        if (variable != null && !variable.isEmpty()) {
            this.variable = variable;
        }
    }

    @DataBoundSetter
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String toString() {
        if (this.label != null) {
            if (this.quantity > 0) {
                return "Label: " + this.label + ", Quantity: " + this.quantity;
            }
            return "Label: " + this.label;
        }
        if (this.resource != null) {
            return this.resource;
        }
        return "[no resource/label specified - probably a bug]";
    }

    public void validate() throws Exception {
        if (this.label != null && !this.label.isEmpty() && this.resource != null && !this.resource.isEmpty()) {
            throw new IllegalArgumentException("Label and resource name cannot be specified simultaneously.");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(LockStepExecution.class);
        }

        public String getFunctionName() {
            return "lock";
        }

        public String getDisplayName() {
            return "Lock shared resource";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public AutoCompletionCandidates doAutoCompleteResource(@QueryParameter String value) {
            return RequiredResourcesProperty.DescriptorImpl.doAutoCompleteResourceNames(value);
        }

        public static FormValidation doCheckLabel(@QueryParameter String value, @QueryParameter String resource) {
            String resourceLabel = Util.fixEmpty((String)value);
            String resourceName = Util.fixEmpty((String)resource);
            if (resourceLabel != null && resourceName != null) {
                return FormValidation.error((String)"Label and resource name cannot be specified simultaneously.");
            }
            if (resourceLabel == null && resourceName == null) {
                return FormValidation.error((String)"Either label or resource name must be specified.");
            }
            return FormValidation.ok();
        }

        public static FormValidation doCheckResource(@QueryParameter String value, @QueryParameter String label) {
            return DescriptorImpl.doCheckLabel(label, value);
        }
    }
}

