/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SerializableSecureGroovyScript
implements Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final String script;
    private final boolean sandbox;
    @Nullable
    private final ArrayList<SerializableClassPathEntry> classPathEntries;
    private static final Logger LOGGER = Logger.getLogger(SerializableSecureGroovyScript.class.getName());

    public SerializableSecureGroovyScript(@CheckForNull SecureGroovyScript secureScript) {
        if (secureScript == null) {
            this.script = null;
            this.sandbox = false;
            this.classPathEntries = null;
        } else {
            this.script = secureScript.getScript();
            this.sandbox = secureScript.isSandbox();
            List classpath = secureScript.getClasspath();
            this.classPathEntries = new ArrayList(classpath.size());
            for (ClasspathEntry e : classpath) {
                this.classPathEntries.add(new SerializableClassPathEntry(e));
            }
        }
    }

    @CheckForNull
    public SecureGroovyScript rehydrate() {
        if (this.script == null) {
            return null;
        }
        ArrayList<ClasspathEntry> p = new ArrayList<ClasspathEntry>(this.classPathEntries.size());
        for (SerializableClassPathEntry e : this.classPathEntries) {
            ClasspathEntry entry = e.rehydrate();
            if (entry == null) continue;
            p.add(entry);
        }
        return new SecureGroovyScript(this.script, this.sandbox, p);
    }

    private static class SerializableClassPathEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String url;

        private SerializableClassPathEntry(@NonNull ClasspathEntry entry) {
            this.url = entry.getPath();
        }

        @CheckForNull
        private ClasspathEntry rehydrate() {
            try {
                ClasspathEntry entry = new ClasspathEntry(this.url);
                if (ScriptApproval.get().checking((ClasspathEntry)entry).kind.equals((Object)FormValidation.Kind.OK)) {
                    return entry;
                }
                return null;
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.SEVERE, "Failed to rehydrate the URL " + this.url + ". It will be skipped", ex);
                return null;
            }
        }
    }
}

