/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.EnvVars;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.Map;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;

public final class Utils {
    private Utils() {
    }

    public static Job<?, ?> getProject(Queue.Item item) {
        if (item.task instanceof Job) {
            return (Job)item.task;
        }
        return null;
    }

    public static Job<?, ?> getProject(Run<?, ?> build) {
        Job p = build.getParent();
        return p;
    }

    public static LockableResourcesStruct requiredResources(Job<?, ?> project) {
        RequiredResourcesProperty property;
        EnvVars env = new EnvVars();
        if (project instanceof MatrixConfiguration) {
            env.putAll((Map)((MatrixConfiguration)project).getCombination());
            project = (Job)project.getParent();
        }
        if ((property = (RequiredResourcesProperty)project.getProperty(RequiredResourcesProperty.class)) != null) {
            return new LockableResourcesStruct(property, env);
        }
        return null;
    }
}

