/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.util.SerializableSecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;

public class LockableResourcesStruct
implements Serializable {
    public List<LockableResource> required = new ArrayList<LockableResource>();
    public String label;
    public String requiredVar;
    public String requiredNumber;
    @CheckForNull
    private final SerializableSecureGroovyScript serializableResourceMatchScript;
    @CheckForNull
    private transient SecureGroovyScript resourceMatchScript;
    private static final long serialVersionUID = 1L;

    public LockableResourcesStruct(RequiredResourcesProperty property, EnvVars env) {
        LockableResourcesManager resourcesManager = LockableResourcesManager.get();
        for (String name : property.getResources()) {
            String resourceName = env.expand(name);
            if (resourceName == null) continue;
            resourcesManager.createResource(resourceName);
            LockableResource r = resourcesManager.fromName(resourceName);
            this.required.add(r);
        }
        this.label = env.expand(property.getLabelName());
        if (this.label == null) {
            this.label = "";
        }
        this.resourceMatchScript = property.getResourceMatchScript();
        this.serializableResourceMatchScript = new SerializableSecureGroovyScript(this.resourceMatchScript);
        this.requiredVar = property.getResourceNamesVar();
        this.requiredNumber = property.getResourceNumber();
        if (this.requiredNumber != null && this.requiredNumber.equals("0")) {
            this.requiredNumber = null;
        }
    }

    public LockableResourcesStruct(@Nullable List<String> resources) {
        this(resources, null, 0);
    }

    public LockableResourcesStruct(@Nullable List<String> resources, @Nullable String label, int quantity, String variable) {
        this(resources, label, quantity);
        this.requiredVar = variable;
    }

    public LockableResourcesStruct(@Nullable List<String> resources, @Nullable String label, int quantity) {
        if (resources != null) {
            for (String resource : resources) {
                LockableResource r = LockableResourcesManager.get().fromName(resource);
                if (r == null) continue;
                this.required.add(r);
            }
        }
        this.label = label;
        if (this.label == null) {
            this.label = "";
        }
        this.requiredNumber = null;
        if (quantity > 0) {
            this.requiredNumber = String.valueOf(quantity);
        }
        this.serializableResourceMatchScript = null;
        this.resourceMatchScript = null;
    }

    @CheckForNull
    public SecureGroovyScript getResourceMatchScript() {
        if (this.resourceMatchScript == null && this.serializableResourceMatchScript != null) {
            this.resourceMatchScript = this.serializableResourceMatchScript.rehydrate();
        }
        return this.resourceMatchScript;
    }

    public String toString() {
        return "Required resources: " + this.required + ", Required label: " + this.label + ", Required label script: " + (this.resourceMatchScript != null ? this.resourceMatchScript.getScript() : "") + ", Variable name: " + this.requiredVar + ", Number of resources: " + this.requiredNumber;
    }
}

