/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.tasks.Mailer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class LockableResource
extends AbstractDescribableImpl<LockableResource>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(LockableResource.class.getName());
    public static final int NOT_QUEUED = 0;
    private static final int QUEUE_TIMEOUT = 60;
    public static final String GROOVY_LABEL_MARKER = "groovy:";
    private final String name;
    private String description = "";
    private String labels = "";
    private String reservedBy = null;
    private boolean ephemeral;
    private long queueItemId = 0L;
    private String queueItemProject = null;
    private transient Run<?, ?> build = null;
    private String buildExternalizableId = null;
    private long queuingStarted = 0L;
    @Deprecated
    private List<StepContext> queuedContexts = new ArrayList<StepContext>();
    private static final long serialVersionUID = 1L;

    @Deprecated
    public LockableResource(String name, String description, String labels, String reservedBy) {
        this.name = name;
        this.description = description;
        this.labels = labels;
        this.reservedBy = Util.fixEmptyAndTrim((String)reservedBy);
    }

    @DataBoundConstructor
    public LockableResource(String name) {
        this.name = name;
    }

    protected Object readResolve() {
        if (this.queuedContexts == null) {
            this.queuedContexts = new ArrayList<StepContext>();
        }
        return this;
    }

    @Deprecated
    public List<StepContext> getQueuedContexts() {
        return this.queuedContexts;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public String getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    @Exported
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isValidLabel(String candidate, Map<String, Object> params) {
        return this.labelsContain(candidate);
    }

    private boolean labelsContain(String candidate) {
        return this.makeLabelsList().contains(candidate);
    }

    private List<String> makeLabelsList() {
        return Arrays.asList(this.labels.split("\\s+"));
    }

    @Restricted(value={NoExternalUse.class})
    public boolean scriptMatches(@NonNull SecureGroovyScript script, @CheckForNull Map<String, Object> params) throws ExecutionException {
        Binding binding = new Binding(params);
        binding.setVariable("resourceName", (Object)this.name);
        binding.setVariable("resourceDescription", (Object)this.description);
        binding.setVariable("resourceLabels", this.makeLabelsList());
        try {
            Object result = script.evaluate(Jenkins.get().getPluginManager().uberClassLoader, binding);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Checked resource " + this.name + " for " + script.getScript() + " with " + binding + " -> " + result);
            }
            return (Boolean)result;
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot get boolean result out of groovy expression. See system log for more info", e);
        }
    }

    @Exported
    public String getReservedBy() {
        return this.reservedBy;
    }

    @Exported
    public boolean isReserved() {
        return this.reservedBy != null;
    }

    @Exported
    public String getReservedByEmail() {
        if (this.reservedBy != null) {
            Mailer.UserProperty email = null;
            User user = Jenkins.get().getUser(this.reservedBy);
            if (user != null) {
                email = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            }
            if (email != null) {
                return email.getAddress();
            }
        }
        return null;
    }

    public boolean isQueued() {
        this.validateQueuingTimeout();
        return this.queueItemId != 0L;
    }

    public boolean isQueued(long taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId != 0L && this.queueItemId != taskId;
    }

    public boolean isQueuedByTask(long taskId) {
        this.validateQueuingTimeout();
        return this.queueItemId == taskId;
    }

    public void unqueue() {
        this.queueItemId = 0L;
        this.queueItemProject = null;
        this.queuingStarted = 0L;
    }

    @Exported
    public boolean isLocked() {
        return this.getBuild() != null;
    }

    @CheckForNull
    public String getLockCause() {
        if (this.isReserved()) {
            return String.format("[%s] is reserved by %s", this.name, this.reservedBy);
        }
        if (this.isLocked()) {
            return String.format("[%s] is locked by %s", this.name, this.buildExternalizableId);
        }
        return null;
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public Run<?, ?> getBuild() {
        if (this.build == null && this.buildExternalizableId != null) {
            this.build = Run.fromExternalizableId((String)this.buildExternalizableId);
        }
        return this.build;
    }

    @Deprecated
    private Object getAbstractBuild(Run<?, ?> owner, Class<?> targetClass) {
        return owner instanceof AbstractBuild ? (AbstractBuild)owner : null;
    }

    @Exported
    public String getBuildName() {
        if (this.getBuild() != null) {
            return this.getBuild().getFullDisplayName();
        }
        return null;
    }

    public void setBuild(Run<?, ?> lockedBy) {
        this.build = lockedBy;
        this.buildExternalizableId = lockedBy != null ? lockedBy.getExternalizableId() : null;
    }

    public Queue.Task getTask() {
        Queue.Item item = Queue.getInstance().getItem(this.queueItemId);
        if (item != null) {
            return item.task;
        }
        return null;
    }

    public long getQueueItemId() {
        this.validateQueuingTimeout();
        return this.queueItemId;
    }

    public String getQueueItemProject() {
        this.validateQueuingTimeout();
        return this.queueItemProject;
    }

    public void setQueued(long queueItemId) {
        this.queueItemId = queueItemId;
        this.queuingStarted = System.currentTimeMillis() / 1000L;
    }

    public void setQueued(long queueItemId, String queueProjectName) {
        this.setQueued(queueItemId);
        this.queueItemProject = queueProjectName;
    }

    private void validateQueuingTimeout() {
        long now;
        if (this.queuingStarted > 0L && (now = System.currentTimeMillis() / 1000L) - this.queuingStarted > 60L) {
            this.unqueue();
        }
    }

    @DataBoundSetter
    public void setReservedBy(String userName) {
        this.reservedBy = Util.fixEmptyAndTrim((String)userName);
    }

    public void unReserve() {
        this.reservedBy = null;
    }

    public void reset() {
        this.unReserve();
        this.unqueue();
        this.setBuild(null);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockableResource other = (LockableResource)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockableResource> {
        @NonNull
        public String getDisplayName() {
            return "Resource";
        }
    }
}

