/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class LockableResourcesQueueTaskDispatcher
extends QueueTaskDispatcher {
    private transient Cache<Long, Date> lastLogged = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    static final Logger LOGGER = Logger.getLogger(LockableResourcesQueueTaskDispatcher.class.getName());

    public CauseOfBlockage canRun(Queue.Item item) {
        int resourceNumber;
        if (item.task instanceof MatrixProject) {
            return null;
        }
        Job<?, ?> project = Utils.getProject(item);
        if (project == null) {
            return null;
        }
        LockableResourcesStruct resources = Utils.requiredResources(project);
        if (resources == null || resources.required.isEmpty() && resources.label.isEmpty() && resources.getResourceMatchScript() == null) {
            return null;
        }
        try {
            resourceNumber = Integer.parseInt(resources.requiredNumber);
        }
        catch (NumberFormatException e) {
            resourceNumber = 0;
        }
        LOGGER.finest(project.getName() + " trying to get resources with these details: " + resources);
        if (resourceNumber > 0 || !resources.label.isEmpty() || resources.getResourceMatchScript() != null) {
            List<LockableResource> selected;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (item.task instanceof MatrixConfiguration) {
                MatrixConfiguration matrix = (MatrixConfiguration)item.task;
                params.putAll((Map<String, Object>)matrix.getCombination());
            }
            try {
                selected = LockableResourcesManager.get().tryQueue(resources, item.getId(), project.getFullName(), resourceNumber, params, LOGGER);
            }
            catch (ExecutionException ex) {
                Throwable toReport = ex.getCause();
                if (toReport == null) {
                    toReport = ex;
                }
                if (LOGGER.isLoggable(Level.WARNING) && this.lastLogged.getIfPresent((Object)item.getId()) == null) {
                    this.lastLogged.put((Object)item.getId(), (Object)new Date());
                    String itemName = project.getFullName() + " (id=" + item.getId() + ")";
                    LOGGER.log(Level.WARNING, "Failed to queue item " + itemName, toReport.getMessage());
                }
                return new BecauseResourcesQueueFailed(resources, toReport);
            }
            if (selected != null) {
                LOGGER.finest(project.getName() + " reserved resources " + selected);
                return null;
            }
            LOGGER.finest(project.getName() + " waiting for resources");
            return new BecauseResourcesLocked(resources);
        }
        if (LockableResourcesManager.get().queue(resources.required, item.getId())) {
            LOGGER.finest(project.getName() + " reserved resources " + resources.required);
            return null;
        }
        LOGGER.finest(project.getName() + " waiting for resources " + resources.required);
        return new BecauseResourcesLocked(resources);
    }

    @Restricted(value={NoExternalUse.class})
    public static class BecauseResourcesQueueFailed
    extends CauseOfBlockage {
        @NonNull
        private final LockableResourcesStruct resources;
        @NonNull
        private final Throwable cause;

        public BecauseResourcesQueueFailed(@NonNull LockableResourcesStruct resources, @NonNull Throwable cause) {
            this.cause = cause;
            this.resources = resources;
        }

        public String getShortDescription() {
            String resourceInfo = this.resources.label.isEmpty() ? this.resources.required.toString() : "with label " + this.resources.label;
            return "Execution failed while acquiring the resource " + resourceInfo + ". " + this.cause.getMessage();
        }
    }

    public static class BecauseResourcesLocked
    extends CauseOfBlockage {
        private final LockableResourcesStruct rscStruct;

        public BecauseResourcesLocked(LockableResourcesStruct r) {
            this.rscStruct = r;
        }

        public String getShortDescription() {
            if (this.rscStruct.label.isEmpty()) {
                return "Waiting for resources " + this.rscStruct.required.toString();
            }
            return "Waiting for resources with label " + this.rscStruct.label;
        }
    }
}

