/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public final class BackwardCompatibility {
    private static final Logger LOG = Logger.getLogger(BackwardCompatibility.class.getName());

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void compatibilityMigration() {
        LOG.log(Level.FINE, "lockable-resource-plugin compatibility migration task run");
        List<LockableResource> resources = LockableResourcesManager.get().getResources();
        for (LockableResource resource : resources) {
            List<StepContext> queuedContexts = resource.getQueuedContexts();
            if (queuedContexts.size() <= 0) continue;
            for (StepContext queuedContext : queuedContexts) {
                ArrayList<String> resourcesNames = new ArrayList<String>();
                resourcesNames.add(resource.getName());
                LockableResourcesStruct resourceHolder = new LockableResourcesStruct(resourcesNames, "", 0);
                LockableResourcesManager.get().queueContext(queuedContext, resourceHolder, resource.getName());
            }
            queuedContexts.clear();
        }
    }
}

