/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import hudson.model.Action;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class LockedResourcesBuildAction
implements Action {
    private final List<ResourcePOJO> lockedResources;

    public LockedResourcesBuildAction(List<ResourcePOJO> lockedResources) {
        this.lockedResources = lockedResources;
    }

    public List<ResourcePOJO> getLockedResources() {
        return this.lockedResources;
    }

    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    public String getDisplayName() {
        return Messages.LockedResourcesBuildAction_displayName();
    }

    public String getUrlName() {
        return "locked-resources";
    }

    @Restricted(value={NoExternalUse.class})
    public static void updateAction(Run<?, ?> build, List<String> resourceNames) {
        LockedResourcesBuildAction action = (LockedResourcesBuildAction)build.getAction(LockedResourcesBuildAction.class);
        if (action == null) {
            ArrayList<ResourcePOJO> resPojos = new ArrayList<ResourcePOJO>();
            action = new LockedResourcesBuildAction(resPojos);
            build.addAction((Action)action);
        }
        for (String name : resourceNames) {
            LockableResource r = LockableResourcesManager.get().fromName(name);
            if (r != null) {
                action.add(new ResourcePOJO(r));
                continue;
            }
            action.add(new ResourcePOJO(name, ""));
        }
    }

    @Restricted(value={NoExternalUse.class})
    private void add(ResourcePOJO r) {
        for (ResourcePOJO pojo : this.lockedResources) {
            if (!pojo.getName().equals(r.getName())) continue;
            pojo.inc();
            return;
        }
        this.lockedResources.add(r);
    }

    @Restricted(value={NoExternalUse.class})
    public static LockedResourcesBuildAction fromResources(Collection<LockableResource> resources) {
        ArrayList<ResourcePOJO> resPojos = new ArrayList<ResourcePOJO>();
        for (LockableResource r : resources) {
            if (r == null) continue;
            resPojos.add(new ResourcePOJO(r));
        }
        return new LockedResourcesBuildAction(resPojos);
    }

    public static class ResourcePOJO {
        private String name;
        private String description;
        private int count = 1;

        public ResourcePOJO(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public ResourcePOJO(LockableResource r) {
            this.name = r.getName();
            this.description = r.getDescription();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCounter() {
            return this.count;
        }

        public void inc() {
            ++this.count;
        }
    }
}

