/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockStepResource;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourceProperty;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.ResourceSelectStrategy;
import org.jenkins.plugins.lockableresources.actions.LockedResourcesBuildAction;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class LockStepExecution
extends AbstractStepExecutionImpl
implements Serializable {
    private static final long serialVersionUID = 1391734561272059623L;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private final LockStep step;

    public LockStepExecution(LockStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() throws Exception {
        this.step.validate();
        ResourceSelectStrategy resourceSelectStrategy = ResourceSelectStrategy.valueOf(this.step.resourceSelectStrategy.toUpperCase(Locale.ENGLISH));
        ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new PauseAction("Lock"));
        PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
        Run run = (Run)this.getContext().get(Run.class);
        LockableResourcesManager.printLogs("Trying to acquire lock on [" + this.step + "]", Level.FINE, LOGGER, logger);
        ArrayList<LockableResourcesStruct> resourceHolderList = new ArrayList<LockableResourcesStruct>();
        LockableResourcesManager lrm = LockableResourcesManager.get();
        List<LockableResource> available = null;
        LinkedHashMap<String, List<LockableResourceProperty>> resourceNames = new LinkedHashMap<String, List<LockableResourceProperty>>();
        Object object = LockableResourcesManager.syncResources;
        synchronized (object) {
            boolean lockFailed;
            for (LockStepResource resource : this.step.getResources()) {
                ArrayList<String> resources = new ArrayList<String>();
                if (resource.resource != null) {
                    if (lrm.createResource(resource.resource)) {
                        LockableResourcesManager.printLogs("Resource [" + resource.resource + "] did not exist. Created.", Level.INFO, LOGGER, logger);
                    }
                    resources.add(resource.resource);
                }
                resourceHolderList.add(new LockableResourcesStruct(resources, resource.label, resource.quantity));
            }
            available = lrm.getAvailableResources(resourceHolderList, logger, resourceSelectStrategy);
            if (available == null || available.isEmpty()) {
                LOGGER.fine("No available resources: " + available);
                this.onLockFailed(logger, resourceHolderList);
                return false;
            }
            boolean bl = lockFailed = !lrm.lock(available, run);
            if (lockFailed) {
                LOGGER.warning("Internal program error: Can not lock resources: " + available);
                this.onLockFailed(logger, resourceHolderList);
                return true;
            }
            for (LockableResource resource : available) {
                resourceNames.put(resource.getName(), resource.getProperties());
            }
        }
        LockStepExecution.proceed(resourceNames, this.getContext(), this.step.toString(), this.step.variable, this.step.inversePrecedence);
        return false;
    }

    private void onLockFailed(PrintStream logger, List<LockableResourcesStruct> resourceHolderList) {
        if (this.step.skipIfLocked) {
            this.printBlockCause(logger, resourceHolderList);
            LockableResourcesManager.printLogs("[" + this.step + "] is not free, skipping execution ...", Level.INFO, LOGGER, logger);
            this.getContext().onSuccess(null);
        } else {
            this.printBlockCause(logger, resourceHolderList);
            LockableResourcesManager.printLogs("[" + this.step + "] is not free, waiting for execution ...", Level.INFO, LOGGER, logger);
            LockableResourcesManager lrm = LockableResourcesManager.get();
            lrm.queueContext(this.getContext(), resourceHolderList, this.step.toString(), this.step.variable);
        }
    }

    private void printBlockCause(PrintStream logger, List<LockableResourcesStruct> resourceHolderList) {
        LockableResource resource;
        LockableResourcesManager lrm = LockableResourcesManager.get();
        LockableResource lockableResource = resource = this.step.resource != null ? lrm.fromName(this.step.resource) : null;
        if (resource != null) {
            String logMessage = resource.getLockCauseDetail();
            if (logMessage != null && !logMessage.isEmpty()) {
                LockableResourcesManager.printLogs(logMessage, Level.INFO, LOGGER, logger);
            }
        } else {
            lrm.getAvailableResources(resourceHolderList, logger, null);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="not sure which exceptions might be catch.")
    public static void proceed(final LinkedHashMap<String, List<LockableResourceProperty>> lockedResources, StepContext context, String resourceDescription, final String variable, boolean inversePrecedence) {
        Run build;
        FlowNode node = null;
        PrintStream logger = null;
        try {
            build = (Run)context.get(Run.class);
            node = (FlowNode)context.get(FlowNode.class);
            logger = ((TaskListener)context.get(TaskListener.class)).getLogger();
            LockableResourcesManager.printLogs("Lock acquired on [" + resourceDescription + "]", Level.INFO, LOGGER, logger);
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        try {
            LockedResourcesBuildAction.updateAction(build, new ArrayList<String>(lockedResources.keySet()));
            PauseAction.endCurrentPause((FlowNode)node);
            BodyInvoker bodyInvoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(new ArrayList<String>(lockedResources.keySet()), resourceDescription, inversePrecedence));
            if (variable != null && !variable.isEmpty()) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new EnvironmentExpander(){
                    private static final long serialVersionUID = -3431466225193397896L;

                    public void expand(@NonNull EnvVars env) {
                        LinkedHashMap<Object, String> variables = new LinkedHashMap<Object, String>();
                        String resourceNames = lockedResources.keySet().stream().collect(Collectors.joining(","));
                        variables.put(variable, resourceNames);
                        int index = 0;
                        for (Map.Entry lockResourceEntry : lockedResources.entrySet()) {
                            String lockEnvName = variable + index;
                            variables.put(lockEnvName, (String)lockResourceEntry.getKey());
                            for (LockableResourceProperty lockProperty : (List)lockResourceEntry.getValue()) {
                                String propEnvName = lockEnvName + "_" + lockProperty.getName();
                                variables.put(propEnvName, lockProperty.getValue());
                            }
                            ++index;
                        }
                        LOGGER.finest("Setting " + variables.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ")) + " for the duration of the block");
                        env.overrideAll(variables);
                    }
                }));
            }
            bodyInvoker.start();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warning("proceed done with failure " + resourceDescription);
            throw new RuntimeException(e);
        }
    }

    public void stop(@NonNull Throwable cause) {
        boolean cleaned = LockableResourcesManager.get().unqueueContext(this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource waiting list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = -2024890670461847666L;
        private final List<String> resourceNames;
        private final String resourceDescription;
        private final boolean inversePrecedence;

        Callback(List<String> resourceNames, String resourceDescription, boolean inversePrecedence) {
            this.resourceNames = resourceNames;
            this.resourceDescription = resourceDescription;
            this.inversePrecedence = inversePrecedence;
        }

        protected void finished(StepContext context) throws Exception {
            LockableResourcesManager.get().unlockNames(this.resourceNames, (Run)context.get(Run.class), this.inversePrecedence);
            LockableResourcesManager.printLogs("Lock released on resource [" + this.resourceDescription + "]", Level.INFO, LOGGER, ((TaskListener)context.get(TaskListener.class)).getLogger());
        }
    }
}

