/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkins.plugins.lockableresources.ExcludeFromJacocoGeneratedReport;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RequiredResourcesProperty
extends JobProperty<Job<?, ?>> {
    private final String resourceNames;
    private final String resourceNamesVar;
    private final String resourceNumber;
    private final String labelName;
    @CheckForNull
    private final SecureGroovyScript resourceMatchScript;

    @DataBoundConstructor
    public RequiredResourcesProperty(String resourceNames, String resourceNamesVar, String resourceNumber, String labelName, @CheckForNull SecureGroovyScript resourceMatchScript) {
        String labelNamePreparation;
        this.resourceNames = resourceNames == null || resourceNames.trim().isEmpty() ? null : resourceNames.trim();
        this.resourceNamesVar = resourceNamesVar == null || resourceNamesVar.trim().isEmpty() ? null : resourceNamesVar.trim();
        this.resourceNumber = resourceNumber == null || resourceNumber.trim().isEmpty() ? null : resourceNumber.trim();
        String string = labelNamePreparation = labelName == null || labelName.trim().isEmpty() ? null : labelName.trim();
        if (resourceMatchScript != null) {
            this.resourceMatchScript = resourceMatchScript.configuringWithKeyItem();
            this.labelName = labelNamePreparation;
        } else if (labelName != null && labelName.startsWith("groovy:")) {
            this.resourceMatchScript = new SecureGroovyScript(labelName.substring("groovy:".length()), false, null).configuring(ApprovalContext.create());
            this.labelName = null;
        } else {
            this.resourceMatchScript = null;
            this.labelName = labelNamePreparation;
        }
    }

    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    public RequiredResourcesProperty(String resourceNames, String resourceNamesVar, String resourceNumber, String labelName) {
        this(resourceNames, resourceNamesVar, resourceNumber, labelName, null);
    }

    private Object readResolve() {
        if (this.resourceMatchScript == null && this.labelName != null && this.labelName.startsWith("groovy:")) {
            return new RequiredResourcesProperty(this.resourceNames, this.resourceNamesVar, this.resourceNumber, null, new SecureGroovyScript(this.labelName.substring("groovy:".length()), false, null).configuring(ApprovalContext.create()));
        }
        return this;
    }

    public String[] getResources() {
        String names = Util.fixEmptyAndTrim((String)this.resourceNames);
        if (names != null) {
            return names.split("\\s+");
        }
        return new String[0];
    }

    public String getResourceNames() {
        return this.resourceNames;
    }

    public String getResourceNamesVar() {
        return this.resourceNamesVar;
    }

    public String getResourceNumber() {
        return this.resourceNumber;
    }

    public String getLabelName() {
        return this.labelName;
    }

    @CheckForNull
    public SecureGroovyScript getResourceMatchScript() {
        return this.resourceMatchScript;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.RequiredResourcesProperty_displayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public RequiredResourcesProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.containsKey((Object)"required-lockable-resources")) {
                return (RequiredResourcesProperty)super.newInstance(req, formData.getJSONObject("required-lockable-resources"));
            }
            return null;
        }

        @RequirePOST
        public FormValidation doCheckResourceNames(@QueryParameter String value, @QueryParameter String labelName, @QueryParameter boolean script, @AncestorInPath Item item) {
            DescriptorImpl.checkPermission(item);
            String labelVal = Util.fixEmptyAndTrim((String)labelName);
            String names = Util.fixEmptyAndTrim((String)value);
            if (names == null) {
                return FormValidation.ok();
            }
            if (labelVal != null || script) {
                return FormValidation.error((String)Messages.error_labelAndNameOrGroovySpecified());
            }
            ArrayList<String> wrongNames = new ArrayList<String>();
            for (String name : names.split("\\s+")) {
                boolean found = false;
                for (LockableResource r : LockableResourcesManager.get().getResources()) {
                    if (!r.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                wrongNames.add(name);
            }
            if (wrongNames.isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.error_resourceDoesNotExist(wrongNames));
        }

        @RequirePOST
        public FormValidation doCheckLabelName(@QueryParameter String value, @QueryParameter String resourceNames, @QueryParameter boolean script, @AncestorInPath Item item) {
            DescriptorImpl.checkPermission(item);
            String label = Util.fixEmptyAndTrim((String)value);
            String names = Util.fixEmptyAndTrim((String)resourceNames);
            if (label == null) {
                return FormValidation.ok();
            }
            if (names != null || script) {
                return FormValidation.error((String)Messages.error_labelAndNameOrGroovySpecified());
            }
            if (LockableResourcesManager.get().isValidLabel(label).booleanValue()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.error_labelDoesNotExist(label));
        }

        @RequirePOST
        public FormValidation doCheckResourceNumber(@QueryParameter String value, @QueryParameter String resourceNames, @QueryParameter String labelName, @QueryParameter String resourceMatchScript, @AncestorInPath Item item) {
            int numAsInt;
            DescriptorImpl.checkPermission(item);
            String number = Util.fixEmptyAndTrim((String)value);
            String names = Util.fixEmptyAndTrim((String)resourceNames);
            String label = Util.fixEmptyAndTrim((String)labelName);
            String script = Util.fixEmptyAndTrim((String)resourceMatchScript);
            if (number == null || number.equals("") || number.trim().equals("0")) {
                return FormValidation.ok();
            }
            try {
                numAsInt = Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.error_couldNotParseToint());
            }
            int numResources = 0;
            if (names != null) {
                numResources = names.split("\\s+").length;
            } else if (label != null || script != null) {
                numResources = Integer.MAX_VALUE;
            }
            if (numResources < numAsInt) {
                return FormValidation.error((String)String.format(Messages.error_givenAmountIsGreaterThatResurcesAmount(), numAsInt, numResources));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public AutoCompletionCandidates doAutoCompleteLabelName(@QueryParameter String value, @AncestorInPath Item item) {
            DescriptorImpl.checkPermission(item);
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            value = Util.fixEmptyAndTrim((String)value);
            for (String l : LockableResourcesManager.get().getAllLabels()) {
                if (value == null || !l.startsWith(value)) continue;
                c.add(l);
            }
            return c;
        }

        @RequirePOST
        public static AutoCompletionCandidates doAutoCompleteResourceNames(@QueryParameter String value, @AncestorInPath Item item) {
            DescriptorImpl.checkPermission(item);
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            value = Util.fixEmptyAndTrim((String)value);
            if (value != null) {
                for (LockableResource r : LockableResourcesManager.get().getResources()) {
                    if (!r.getName().startsWith(value)) continue;
                    c.add(r.getName());
                }
            }
            return c;
        }

        private static void checkPermission(Item item) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
        }
    }
}

