/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;

@Extension
public class LockableResourcesQueueTaskDispatcher
extends QueueTaskDispatcher {
    static final Logger LOGGER = Logger.getLogger(LockableResourcesQueueTaskDispatcher.class.getName());

    public CauseOfBlockage canRun(Queue.Item item) {
        int resourceNumber;
        if (item.task instanceof MatrixProject) {
            return null;
        }
        AbstractProject<?, ?> project = Utils.getProject(item);
        if (project == null) {
            return null;
        }
        LockableResourcesStruct resources = Utils.requiredResources(project);
        if (resources == null || resources.required.isEmpty() && resources.label.isEmpty()) {
            return null;
        }
        try {
            resourceNumber = Integer.parseInt(resources.requiredNumber);
        }
        catch (NumberFormatException e) {
            resourceNumber = 0;
        }
        LOGGER.finest(project.getName() + " trying to get resources with these details: " + resources);
        if (resourceNumber > 0 || !resources.label.isEmpty()) {
            List<LockableResource> selected;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (item.task instanceof MatrixConfiguration) {
                MatrixConfiguration matrix = (MatrixConfiguration)item.task;
                params.putAll((Map<String, Object>)matrix.getCombination());
            }
            if ((selected = LockableResourcesManager.get().queue(resources, item.getId(), project.getFullName(), resourceNumber, params, LOGGER)) != null) {
                LOGGER.finest(project.getName() + " reserved resources " + selected);
                return null;
            }
            LOGGER.finest(project.getName() + " waiting for resources");
            return new BecauseResourcesLocked(resources);
        }
        if (LockableResourcesManager.get().queue(resources.required, item.getId())) {
            LOGGER.finest(project.getName() + " reserved resources " + resources.required);
            return null;
        }
        LOGGER.finest(project.getName() + " waiting for resources " + resources.required);
        return new BecauseResourcesLocked(resources);
    }

    public static class BecauseResourcesLocked
    extends CauseOfBlockage {
        private final LockableResourcesStruct rscStruct;

        public BecauseResourcesLocked(LockableResourcesStruct r) {
            this.rscStruct = r;
        }

        public String getShortDescription() {
            if (this.rscStruct.label.isEmpty()) {
                return "Waiting for resources " + this.rscStruct.required.toString();
            }
            return "Waiting for resources with label " + this.rscStruct.label;
        }
    }
}

