/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.EnvVars;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;

public class LockableResourcesStruct
implements Serializable {
    public List<LockableResource> required = new ArrayList<LockableResource>();
    public String label;
    public String requiredVar;
    public String requiredNumber;
    private static final long serialVersionUID = 1L;

    public LockableResourcesStruct(RequiredResourcesProperty property, EnvVars env) {
        for (String name : property.getResources()) {
            LockableResource r = LockableResourcesManager.get().fromName(env.expand(name));
            if (r == null) continue;
            this.required.add(r);
        }
        this.label = env.expand(property.getLabelName());
        if (this.label == null) {
            this.label = "";
        }
        this.requiredVar = property.getResourceNamesVar();
        this.requiredNumber = property.getResourceNumber();
        if (this.requiredNumber != null && this.requiredNumber.equals("0")) {
            this.requiredNumber = null;
        }
    }

    public LockableResourcesStruct(String resource) {
        LockableResource r = LockableResourcesManager.get().fromName(resource);
        if (r != null) {
            this.required.add(r);
        }
    }

    public String toString() {
        return "Required resources: " + this.required + ", Required label: " + this.label + ", Variable name: " + this.requiredVar + ", Number of resources: " + this.requiredNumber;
    }
}

