/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.Extension;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.actions.LockedResourcesBuildAction;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;

@Extension
public class LockRunListener
extends RunListener<AbstractBuild<?, ?>> {
    static final String LOG_PREFIX = "[lockable-resources]";
    static final Logger LOGGER = Logger.getLogger(LockRunListener.class.getName());

    public void onStarted(AbstractBuild<?, ?> build, TaskListener listener) {
        LockableResourcesStruct resources;
        if (build instanceof MatrixBuild) {
            return;
        }
        AbstractProject<?, ?> proj = Utils.getProject(build);
        List<Object> required = new ArrayList();
        if (proj != null && (resources = Utils.requiredResources(proj)) != null) {
            required = resources.requiredNumber != null || !resources.label.isEmpty() ? LockableResourcesManager.get().getResourcesFromProject(proj.getFullName()) : resources.required;
            if (LockableResourcesManager.get().lock((List<LockableResource>)required, (Run<?, ?>)build, null)) {
                build.addAction((Action)LockedResourcesBuildAction.fromResources(required));
                listener.getLogger().printf("%s acquired lock on %s\n", LOG_PREFIX, required);
                LOGGER.fine(build.getFullDisplayName() + " acquired lock on " + required);
                if (resources.requiredVar != null) {
                    ArrayList<StringParameterValue> params = new ArrayList<StringParameterValue>();
                    params.add(new StringParameterValue(resources.requiredVar, ((Object)required).toString().replaceAll("[\\]\\[]", "")));
                    build.addAction((Action)new ParametersAction(params));
                }
            } else {
                listener.getLogger().printf("%s failed to lock %s\n", LOG_PREFIX, required);
                LOGGER.fine(build.getFullDisplayName() + " failed to lock " + required);
            }
        }
    }

    public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
        if (build instanceof MatrixBuild) {
            return;
        }
        List<LockableResource> required = LockableResourcesManager.get().getResourcesFromBuild(build);
        if (required.size() > 0) {
            LockableResourcesManager.get().unlock(required, (Run<?, ?>)build, null);
            listener.getLogger().printf("%s released lock on %s\n", LOG_PREFIX, required);
            LOGGER.fine(build.getFullDisplayName() + " released lock on " + required);
        }
    }

    public void onDeleted(AbstractBuild<?, ?> build) {
        if (build instanceof MatrixBuild) {
            return;
        }
        List<LockableResource> required = LockableResourcesManager.get().getResourcesFromBuild(build);
        if (required.size() > 0) {
            LockableResourcesManager.get().unlock(required, (Run<?, ?>)build, null);
            LOGGER.fine(build.getFullDisplayName() + " released lock on " + required);
        }
    }
}

