/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import com.google.inject.Inject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockStep;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class LockStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private LockStep step;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient TaskListener listener;
    private static final Logger LOGGER = Logger.getLogger(LockStepExecution.class.getName());
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        if (LockableResourcesManager.get().createResource(this.step.resource)) {
            this.listener.getLogger().println("Resource [" + this.step.resource + "] did not exist. Created.");
        }
        this.listener.getLogger().println("Trying to acquire lock on [" + this.step.resource + "]");
        LockableResourcesStruct resourceHolder = new LockableResourcesStruct(this.step.resource);
        if (!LockableResourcesManager.get().lock(resourceHolder.required, this.run, this.getContext(), this.step.inversePrecedence)) {
            this.listener.getLogger().println("[" + this.step.resource + "] is locked, waiting...");
        }
        return false;
    }

    public static void proceed(StepContext context, String resource, boolean inversePrecedence) {
        LockableResourcesStruct resourceHolder = new LockableResourcesStruct(resource);
        Run r = null;
        try {
            r = (Run)context.get(Run.class);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock acquired on [" + resource + "]");
        }
        catch (Exception e) {
            context.onFailure((Throwable)e);
            return;
        }
        LOGGER.finest("Lock acquired on [" + resource + "] by " + r.getExternalizableId());
        context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(resourceHolder, inversePrecedence)).withDisplayName(null).start();
    }

    public void stop(Throwable cause) throws Exception {
        boolean cleaned = LockableResourcesManager.get().cleanWaitingContext(LockableResourcesManager.get().fromName(this.step.resource), this.getContext());
        if (!cleaned) {
            LOGGER.log(Level.WARNING, "Cannot remove context from lockable resource witing list. The context is not in the waiting list.");
        }
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private final LockableResourcesStruct resourceHolder;
        private final boolean inversePrecedence;
        private static final long serialVersionUID = 1L;

        Callback(LockableResourcesStruct resourceHolder, boolean inversePrecedence) {
            this.resourceHolder = resourceHolder;
            this.inversePrecedence = inversePrecedence;
        }

        protected void finished(StepContext context) throws Exception {
            LockableResourcesManager.get().unlock(this.resourceHolder.required, (Run)context.get(Run.class), context, this.inversePrecedence);
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Lock released on resouce [" + this.resourceHolder.required.get(0) + "]");
            LOGGER.finest("Lock released on [" + this.resourceHolder.required.get(0) + "]");
        }
    }
}

