/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.EnvVars;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.Map;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static AbstractProject<?, ?> getProject(Queue.Item item) {
        if (item.task instanceof AbstractProject) {
            return (AbstractProject)item.task;
        }
        return null;
    }

    public static AbstractProject<?, ?> getProject(AbstractBuild<?, ?> build) {
        Job p = build.getParent();
        if (p instanceof AbstractProject) {
            return (AbstractProject)p;
        }
        return null;
    }

    public static LockableResourcesStruct requiredResources(AbstractProject<?, ?> project) {
        RequiredResourcesProperty property = null;
        EnvVars env = new EnvVars();
        if (project instanceof MatrixConfiguration) {
            env.putAll((Map)((MatrixConfiguration)project).getCombination());
            project = (AbstractProject)project.getParent();
        }
        if ((property = (RequiredResourcesProperty)project.getProperty(RequiredResourcesProperty.class)) != null) {
            return new LockableResourcesStruct(property, env);
        }
        return null;
    }
}

