/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;

@Extension
public class LockableResourcesQueueTaskDispatcher
extends QueueTaskDispatcher {
    static final Logger LOGGER = Logger.getLogger(LockableResourcesQueueTaskDispatcher.class.getName());

    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        int resourceNumber;
        AbstractProject<?, ?> project = Utils.getProject((Queue.Item)item);
        if (project == null) {
            return null;
        }
        LockableResourcesStruct resources = Utils.requiredResources(project);
        if (resources == null || resources.required.isEmpty()) {
            return null;
        }
        try {
            resourceNumber = Integer.parseInt(resources.requiredNumber);
        }
        catch (NumberFormatException e) {
            resourceNumber = 0;
        }
        if (resourceNumber > 0) {
            List<Object> selected = new ArrayList();
            LOGGER.finest(project.getName() + " trying to reserve " + resourceNumber + " of " + resources.required);
            selected = LockableResourcesManager.get().queue(resources.required, item.id, project.getFullName(), resourceNumber);
            if (selected != null) {
                LOGGER.finest(project.getName() + " reserved resources " + selected);
                return null;
            }
            LOGGER.finest(project.getName() + " waiting for resources");
            return new BecauseResourcesLocked(resources.required);
        }
        LOGGER.finest(project.getName() + " trying to reserve resources " + resources.required);
        if (LockableResourcesManager.get().queue(resources.required, item.id)) {
            LOGGER.finest(project.getName() + " reserved resources " + resources.required);
            return null;
        }
        LOGGER.finest(project.getName() + " waiting for resources " + resources.required);
        return new BecauseResourcesLocked(resources.required);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BecauseResourcesLocked
    extends CauseOfBlockage {
        private final List<LockableResource> resources;

        public BecauseResourcesLocked(List<LockableResource> resources) {
            this.resources = resources;
        }

        public List<LockableResource> getResources() {
            return this.resources;
        }

        public String getShortDescription() {
            return "Waiting for resources " + this.resources.toString();
        }
    }
}

