/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class LockableResourcesManager
extends GlobalConfiguration {
    private int defaultPriority = 5;
    private String priorityParameterName = "LOCK_PRIORITY";
    private List<LockableResource> resources = new ArrayList<LockableResource>();

    public LockableResourcesManager() {
        this.load();
    }

    public List<LockableResource> getResources() {
        return this.resources;
    }

    public List<LockableResource> getResourcesFromProject(String fullName) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            String rName = r.getQueueItemProject();
            if (rName == null || !rName.equals(fullName)) continue;
            matching.add(r);
        }
        return matching;
    }

    public List<LockableResource> getResourcesFromBuild(AbstractBuild<?, ?> build) {
        ArrayList<LockableResource> matching = new ArrayList<LockableResource>();
        for (LockableResource r : this.resources) {
            AbstractBuild<?, ?> rBuild = r.getBuild();
            if (rBuild == null || rBuild != build) continue;
            matching.add(r);
        }
        return matching;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public String getPriorityParameterName() {
        return this.priorityParameterName;
    }

    public LockableResource fromName(String resourceName) {
        if (resourceName != null) {
            for (LockableResource r : this.resources) {
                if (!resourceName.equals(r.getName())) continue;
                return r;
            }
        }
        return null;
    }

    public synchronized boolean queue(List<LockableResource> resources, int queueItemId) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isQueued(queueItemId) && !r.isLocked()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setQueueItemId(queueItemId);
        }
        return true;
    }

    public synchronized List<LockableResource> queue(List<LockableResource> resources, int queueItemId, String queueItemProject, int number) {
        ArrayList<LockableResource> selected = new ArrayList<LockableResource>();
        for (LockableResource r : resources) {
            String rProject = r.getQueueItemProject();
            if (rProject == null || !rProject.equals(queueItemProject)) continue;
            if (r.isQueued(queueItemId)) {
                selected.add(r);
                continue;
            }
            return null;
        }
        for (LockableResource rs : resources) {
            if (selected.size() >= number) break;
            if (rs.isReserved() || rs.isLocked() || rs.isQueued()) continue;
            selected.add(rs);
        }
        if (selected.size() != number) {
            return null;
        }
        for (LockableResource rsc : selected) {
            rsc.setQueueItemId(queueItemId);
            rsc.setQueueItemProject(queueItemProject);
        }
        return selected;
    }

    public synchronized boolean lock(List<LockableResource> resources, AbstractBuild<?, ?> build) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.unqueue();
            r.setBuild(build);
        }
        return true;
    }

    public synchronized void unlock(List<LockableResource> resources, AbstractBuild<?, ?> build) {
        for (LockableResource r : resources) {
            if (build != null && build != r.getBuild()) continue;
            r.unqueue();
            r.setBuild(null);
            r.setQueueItemProject(null);
            r.setQueueItemId(0);
        }
    }

    public synchronized boolean reserve(List<LockableResource> resources, String userName) {
        for (LockableResource r : resources) {
            if (!r.isReserved() && !r.isLocked() && !r.isQueued()) continue;
            return false;
        }
        for (LockableResource r : resources) {
            r.setReservedBy(userName);
        }
        this.save();
        return true;
    }

    public synchronized void unreserve(List<LockableResource> resources) {
        for (LockableResource r : resources) {
            r.unReserve();
        }
        this.save();
    }

    public String getDisplayName() {
        return "External Resources";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            this.defaultPriority = json.getInt("defaultPriority");
            this.priorityParameterName = json.getString("priorityParameterName");
            List newResouces = req.bindJSONToList(LockableResource.class, json.get("resources"));
            for (LockableResource r : newResouces) {
                LockableResource old = this.fromName(r.getName());
                if (old == null) continue;
                r.setBuild(old.getBuild());
                r.setQueueItemId(r.getQueueItemId());
            }
            this.resources = newResouces;
            this.save();
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static LockableResourcesManager get() {
        return (LockableResourcesManager)Jenkins.getInstance().getDescriptorOrDie(LockableResourcesManager.class);
    }
}

