/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Queue;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockableResource
extends AbstractDescribableImpl<LockableResource> {
    public static final int NOT_QUEUED = 0;
    private final String name;
    private final String description;
    private String reservedBy;
    private transient int queueItemId = 0;
    private transient String queueItemProject = null;
    private transient AbstractBuild<?, ?> build = null;

    @DataBoundConstructor
    public LockableResource(String name, String description, String reservedBy) {
        this.name = name;
        this.description = description;
        this.reservedBy = Util.fixEmptyAndTrim((String)reservedBy);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReservedBy() {
        return this.reservedBy;
    }

    public boolean isReserved() {
        return this.reservedBy != null;
    }

    public boolean isQueued() {
        return this.queueItemId != 0;
    }

    public boolean isQueued(int taskId) {
        return this.queueItemId != 0 && this.queueItemId != taskId;
    }

    public void unqueue() {
        this.queueItemId = 0;
    }

    public boolean isLocked() {
        return this.build != null;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public void setBuild(AbstractBuild<?, ?> lockedBy) {
        this.build = lockedBy;
    }

    public Queue.Task getTask() {
        Queue.Item item = Queue.getInstance().getItem(this.queueItemId);
        if (item != null) {
            return item.task;
        }
        return null;
    }

    public int getQueueItemId() {
        return this.queueItemId;
    }

    public void setQueueItemId(int queueItemId) {
        this.queueItemId = queueItemId;
    }

    public String getQueueItemProject() {
        return this.queueItemProject;
    }

    public void setQueueItemProject(String queueItemProject) {
        this.queueItemProject = queueItemProject;
    }

    public void setReservedBy(String userName) {
        this.reservedBy = userName;
    }

    public void unReserve() {
        this.reservedBy = null;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LockableResource other = (LockableResource)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<LockableResource> {
        public String getDisplayName() {
            return "Resource";
        }
    }
}

