/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import hudson.Extension;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.actions.LockedResourcesBuildAction;
import org.jenkins.plugins.lockableresources.actions.ResourceVariableNameAction;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.Utils;

@Extension
public class LockRunListener
extends RunListener<Run<?, ?>> {
    static final String LOG_PREFIX = "[lockable-resources]";
    static final Logger LOGGER = Logger.getLogger(LockRunListener.class.getName());

    public void onStarted(Run<?, ?> build, TaskListener listener) {
        if (build instanceof MatrixBuild) {
            return;
        }
        if (build instanceof AbstractBuild) {
            LockableResourcesStruct resources;
            Job<?, ?> proj = Utils.getProject(build);
            List<Object> required = new ArrayList();
            if (proj != null && (resources = Utils.requiredResources(proj)) != null) {
                required = resources.requiredNumber != null || !resources.label.isEmpty() ? LockableResourcesManager.get().getResourcesFromProject(proj.getFullName()) : resources.required;
                if (LockableResourcesManager.get().lock(required, build, null)) {
                    build.addAction((Action)LockedResourcesBuildAction.fromResources(required));
                    listener.getLogger().printf("%s acquired lock on %s\n", LOG_PREFIX, required);
                    LOGGER.fine(build.getFullDisplayName() + " acquired lock on " + required);
                    if (resources.requiredVar != null) {
                        build.addAction((Action)new ResourceVariableNameAction(new StringParameterValue(resources.requiredVar, ((Object)required).toString().replaceAll("[\\]\\[]", ""))));
                    }
                } else {
                    listener.getLogger().printf("%s failed to lock %s\n", LOG_PREFIX, required);
                    LOGGER.fine(build.getFullDisplayName() + " failed to lock " + required);
                }
            }
        }
    }

    public void onCompleted(Run<?, ?> build, TaskListener listener) {
        if (build instanceof MatrixBuild) {
            return;
        }
        List<LockableResource> required = LockableResourcesManager.get().getResourcesFromBuild(build);
        if (required.size() > 0) {
            LockableResourcesManager.get().unlock(required, build, null);
            listener.getLogger().printf("%s released lock on %s\n", LOG_PREFIX, required);
            LOGGER.fine(build.getFullDisplayName() + " released lock on " + required);
        }
    }

    public void onDeleted(Run<?, ?> build) {
        if (build instanceof MatrixBuild) {
            return;
        }
        List<LockableResource> required = LockableResourcesManager.get().getResourcesFromBuild(build);
        if (required.size() > 0) {
            LockableResourcesManager.get().unlock(required, build, null);
            LOGGER.fine(build.getFullDisplayName() + " released lock on " + required);
        }
    }
}

