/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorContext;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionValidatorManager
implements ActionValidatorManager {
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private static final Map validatorCache = Collections.synchronizedMap(new HashMap());
    private static final Map validatorFileCache = Collections.synchronizedMap(new HashMap());
    private static final Log LOG;
    static /* synthetic */ Class class$com$opensymphony$xwork2$validator$DefaultActionValidatorManager;
    static /* synthetic */ Class class$java$lang$Object;

    public synchronized List getValidators(Class clazz, String context) {
        String validatorKey = DefaultActionValidatorManager.buildValidatorKey(clazz, context);
        if (validatorCache.containsKey(validatorKey)) {
            if (FileManager.isReloadingConfigs()) {
                validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, true, null));
            }
        } else {
            validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, false, null));
        }
        List cfgs = (List)validatorCache.get(validatorKey);
        ArrayList<Validator> validators = new ArrayList<Validator>(cfgs.size());
        Iterator iterator = cfgs.iterator();
        while (iterator.hasNext()) {
            ValidatorConfig cfg = (ValidatorConfig)iterator.next();
            Validator validator = ValidatorFactory.getValidator(cfg);
            validator.setValidatorType(cfg.getType());
            validators.add(validator);
        }
        return validators;
    }

    public void validate(Object object, String context) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object);
        this.validate(object, context, validatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        List validators = this.getValidators(object.getClass(), context);
        TreeSet<String> shortcircuitedFields = null;
        Iterator iterator = validators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            try {
                validator.setValidatorContext(validatorContext);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Running validator: " + validator + " for object " + object));
                }
                FieldValidator fValidator = null;
                String fullFieldName = null;
                if (validator instanceof FieldValidator) {
                    fValidator = (FieldValidator)validator;
                    fullFieldName = fValidator.getValidatorContext().getFullFieldName(fValidator.getFieldName());
                    if (shortcircuitedFields != null && shortcircuitedFields.contains(fullFieldName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Short-circuited, skipping");
                        continue;
                    }
                }
                if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)validator)).isShortCircuit()) {
                    Collection errCol;
                    Collection actionErrors;
                    ArrayList errs = null;
                    if (fValidator != null) {
                        Collection fieldErrors;
                        if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) != null) {
                            errs = new ArrayList(fieldErrors);
                        }
                    } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                        errs = new ArrayList(actionErrors);
                    }
                    validator.validate(object);
                    if (fValidator != null) {
                        if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) == null || ((Object)errCol).equals(errs)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Short-circuiting on field validation");
                        }
                        if (shortcircuitedFields == null) {
                            shortcircuitedFields = new TreeSet<String>();
                        }
                        shortcircuitedFields.add(fullFieldName);
                        continue;
                    }
                    if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || ((Object)errCol).equals(errs)) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"Short-circuiting");
                    break;
                }
                validator.validate(object);
            }
            finally {
                validator.setValidatorContext(null);
            }
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private List buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List buildValidatorConfigs(Class clazz, String context, boolean checkFile, Set checked) {
        int x;
        Class<?>[] interfaces;
        ArrayList validatorConfigs = new ArrayList();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return validatorConfigs;
        }
        if (clazz.isInterface()) {
            interfaces = clazz.getInterfaces();
            for (x = 0; x < interfaces.length; ++x) {
                validatorConfigs.addAll(this.buildValidatorConfigs(interfaces[x], context, checkFile, checked));
            }
        } else {
            Class<?> clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            if (!clazz.equals(clazz2)) {
                validatorConfigs.addAll(this.buildValidatorConfigs(clazz.getSuperclass(), context, checkFile, checked));
            }
        }
        interfaces = clazz.getInterfaces();
        for (x = 0; x < interfaces.length; ++x) {
            if (checked.contains(interfaces[x].getName())) continue;
            validatorConfigs.addAll(this.buildClassValidatorConfigs(interfaces[x], checkFile));
            if (context != null) {
                validatorConfigs.addAll(this.buildAliasValidatorConfigs(interfaces[x], context, checkFile));
            }
            checked.add(interfaces[x].getName());
        }
        validatorConfigs.addAll(this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            validatorConfigs.addAll(this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return validatorConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadFile(String fileName, Class clazz, boolean checkFile) {
        ArrayList retList = Collections.EMPTY_LIST;
        if (checkFile && FileManager.fileNeedsReloading(fileName) || !validatorFileCache.containsKey(fileName)) {
            InputStream is = null;
            try {
                is = FileManager.loadFile(fileName, clazz);
                if (is != null) {
                    retList = new ArrayList(ValidatorFileParser.parseActionValidatorConfigs(is, fileName));
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to close input stream for " + fileName), (Throwable)e);
                    }
                }
            }
            validatorFileCache.put(fileName, retList);
        } else {
            retList = (List)validatorFileCache.get(fileName);
        }
        return retList;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$validator$DefaultActionValidatorManager;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$validator$DefaultActionValidatorManager = new DefaultActionValidatorManager[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

