/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.AnnotationValidationConfigurationBuilder;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorContext;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationActionValidatorManager
implements ActionValidatorManager {
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private static final Map<String, List<ValidatorConfig>> validatorCache = Collections.synchronizedMap(new HashMap());
    private static final Map<String, List<ValidatorConfig>> validatorFileCache = Collections.synchronizedMap(new HashMap());
    private static final Log LOG;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$opensymphony$xwork2$validator$AnnotationActionValidatorManager;

    @Override
    public synchronized List<Validator> getValidators(Class clazz, String context) {
        String validatorKey = AnnotationActionValidatorManager.buildValidatorKey(clazz, context);
        if (validatorCache.containsKey(validatorKey)) {
            if (FileManager.isReloadingConfigs()) {
                validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, true, null));
            }
        } else {
            validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, false, null));
        }
        List<ValidatorConfig> cfgs = validatorCache.get(validatorKey);
        ArrayList<Validator> validators = new ArrayList<Validator>(cfgs.size());
        for (ValidatorConfig cfg : cfgs) {
            Validator validator = ValidatorFactory.getValidator(cfg);
            validator.setValidatorType(cfg.getType());
            validators.add(validator);
        }
        return validators;
    }

    @Override
    public void validate(Object object, String context) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object);
        this.validate(object, context, validatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        List<Validator> validators = this.getValidators(object.getClass(), context);
        TreeSet<String> shortcircuitedFields = null;
        for (Validator validator : validators) {
            try {
                validator.setValidatorContext(validatorContext);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("Running validator: ").append(validator).append(" for object ").append(object).toString());
                }
                FieldValidator fValidator = null;
                String fullFieldName = null;
                if (validator instanceof FieldValidator) {
                    fValidator = (FieldValidator)validator;
                    fullFieldName = fValidator.getValidatorContext().getFullFieldName(fValidator.getFieldName());
                    if (shortcircuitedFields != null && shortcircuitedFields.contains(fullFieldName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Short-circuited, skipping");
                        continue;
                    }
                }
                if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)validator)).isShortCircuit()) {
                    Collection errCol;
                    Collection actionErrors;
                    ArrayList errs = null;
                    if (fValidator != null) {
                        Collection fieldErrors;
                        if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) != null) {
                            errs = new ArrayList(fieldErrors);
                        }
                    } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                        errs = new ArrayList(actionErrors);
                    }
                    validator.validate(object);
                    if (fValidator != null) {
                        if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) == null || ((Object)errCol).equals(errs)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Short-circuiting on field validation");
                        }
                        if (shortcircuitedFields == null) {
                            shortcircuitedFields = new TreeSet<String>();
                        }
                        shortcircuitedFields.add(fullFieldName);
                        continue;
                    }
                    if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || ((Object)errCol).equals(errs)) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"Short-circuiting");
                    break;
                }
                validator.validate(object);
            }
            finally {
                validator.setValidatorContext(null);
            }
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private List<ValidatorConfig> buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = new StringBuffer().append(aClass.getName().replace('.', '/')).append("-").append(context).append(VALIDATION_CONFIG_SUFFIX).toString();
        return this.loadFile(fileName, aClass, checkFile);
    }

    protected List<ValidatorConfig> buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = new StringBuffer().append(aClass.getName().replace('.', '/')).append(VALIDATION_CONFIG_SUFFIX).toString();
        ArrayList<ValidatorConfig> result = new ArrayList<ValidatorConfig>(this.loadFile(fileName, aClass, checkFile));
        ArrayList<ValidatorConfig> annotationResult = new ArrayList<ValidatorConfig>(AnnotationValidationConfigurationBuilder.buildAnnotationClassValidatorConfigs(aClass));
        result.addAll(annotationResult);
        return result;
    }

    private List<ValidatorConfig> buildValidatorConfigs(Class clazz, String context, boolean checkFile, Set checked) {
        Class<?>[] interfaces;
        ArrayList<ValidatorConfig> validatorConfigs = new ArrayList<ValidatorConfig>();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return validatorConfigs;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                validatorConfigs.addAll(this.buildValidatorConfigs(anInterface, context, checkFile, checked));
            }
        } else {
            Class<?> clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            if (!clazz.equals(clazz2)) {
                validatorConfigs.addAll(this.buildValidatorConfigs(clazz.getSuperclass(), context, checkFile, checked));
            }
        }
        for (Class<?> anInterface1 : interfaces = clazz.getInterfaces()) {
            if (checked.contains(anInterface1.getName())) continue;
            validatorConfigs.addAll(this.buildClassValidatorConfigs(anInterface1, checkFile));
            if (context != null) {
                validatorConfigs.addAll(this.buildAliasValidatorConfigs(anInterface1, context, checkFile));
            }
            checked.add(anInterface1.getName());
        }
        validatorConfigs.addAll(this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            validatorConfigs.addAll(this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return validatorConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValidatorConfig> loadFile(String fileName, Class clazz, boolean checkFile) {
        List<ValidatorConfig> retList = Collections.EMPTY_LIST;
        if (checkFile && FileManager.fileNeedsReloading(fileName) || !validatorFileCache.containsKey(fileName)) {
            InputStream is = null;
            try {
                is = FileManager.loadFile(fileName, clazz);
                if (is != null) {
                    retList = new ArrayList<ValidatorConfig>(ValidatorFileParser.parseActionValidatorConfigs(is, fileName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)new StringBuffer().append("Caught exception while loading file ").append(fileName).toString(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)new StringBuffer().append("Unable to close input stream for ").append(fileName).toString(), (Throwable)e);
                    }
                }
            }
            validatorFileCache.put(fileName, retList);
        } else {
            retList = validatorFileCache.get(fileName);
        }
        return retList;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$validator$AnnotationActionValidatorManager;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$validator$AnnotationActionValidatorManager = new AnnotationActionValidatorManager[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

