/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ObjectTypeDeterminer;
import com.opensymphony.xwork2.util.ObjectTypeDeterminerFactory;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.XWorkBasicConverter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import ognl.DefaultTypeConverter;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWorkConverter
extends DefaultTypeConverter {
    private static XWorkConverter instance;
    protected static final Log LOG;
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    public static final String LAST_BEAN_CLASS_ACCESSED = "last.bean.accessed";
    public static final String LAST_BEAN_PROPERTY_ACCESSED = "last.property.accessed";
    protected HashMap<Class, Map<String, Object>> mappings = new HashMap();
    protected HashSet<Class> noMapping = new HashSet();
    protected HashMap<String, TypeConverter> defaultMappings = new HashMap();
    protected HashSet<String> unknownMappings = new HashSet();
    protected TypeConverter defaultTypeConverter = new XWorkBasicConverter();
    protected ObjectTypeDeterminer objectTypeDeterminer = ObjectTypeDeterminerFactory.getInstance();
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$XWorkConverter;
    static /* synthetic */ Class class$ognl$TypeConverter;
    static /* synthetic */ Class class$java$lang$Object;

    protected XWorkConverter() {
        try {
            this.loadConversionProperties("xwork-default-conversion.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadConversionProperties("xwork-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConversionErrorMessage(String propertyName, ValueStack stack) {
        String defaultMessage = LocalizedTextUtil.findDefaultText("xwork.default.invalid.fieldvalue", ActionContext.getContext().getLocale(), new Object[]{propertyName});
        String getTextExpression = new StringBuffer().append("getText('invalid.fieldvalue.").append(propertyName).append("','").append(defaultMessage).append("')").toString();
        String message = (String)stack.findValue(getTextExpression);
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }

    public static XWorkConverter getInstance() {
        if (instance == null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.opensymphony.xwork2.util.AnnotationXWorkConverter");
                instance = (XWorkConverter)((Object)clazz.newInstance());
                LOG.info((Object)"Detected AnnotationXWorkConverter, initializing it...");
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                LOG.error((Object)"Exception when trying to create new AnnotationXWorkConverter", (Throwable)e);
            }
            if (instance == null) {
                instance = new XWorkConverter();
            }
        }
        return instance;
    }

    @Inject
    public static void setInstance(XWorkConverter instance) {
        XWorkConverter.instance = instance;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        String resource = new StringBuffer().append(className.replace('.', '/')).append("-conversion.properties").toString();
        return resource;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setDefaultConverter(TypeConverter defaultTypeConverter) {
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map map, Object o, Class aClass) {
        return this.convertValue(map, null, null, null, o, aClass);
    }

    /*
     * Unable to fully structure code
     */
    public Object convertValue(Map context, Object target, Member member, String property, Object value, Class toClass) {
        block23: {
            tc = null;
            if (value != null && toClass == value.getClass()) {
                return value;
            }
            if (target != null) {
                clazz = target.getClass();
                classProp = null;
                if (target instanceof CompoundRoot && context != null) {
                    classProp = this.getClassProperty(context);
                }
                if (classProp != null) {
                    clazz = (Class)classProp[0];
                    property = (String)classProp[1];
                }
                tc = (TypeConverter)this.getConverter(clazz, property);
                if (XWorkConverter.LOG.isDebugEnabled()) {
                    XWorkConverter.LOG.debug((Object)new StringBuffer().append("field-level type converter for property [").append(property).append("] = ").append((Object)(tc == null ? "none found" : tc)).toString());
                }
            }
            if (tc == null && context != null) {
                lastPropertyPath = context.get("current.property.path");
                clazz = (Class)context.get("last.bean.accessed");
                if (lastPropertyPath != null && clazz != null) {
                    path = new StringBuffer().append(lastPropertyPath).append(".").append(property).toString();
                    tc = (TypeConverter)this.getConverter(clazz, path);
                }
            }
            if (tc != null) break block23;
            v0 = XWorkConverter.class$java$lang$String;
            if (v0 == null) {
                v0 = XWorkConverter.class$java$lang$String = new String[0].getClass().getComponentType();
            }
            if (!toClass.equals(v0) || value == null) ** GOTO lbl-1000
            v1 = value.getClass();
            v2 = XWorkConverter.class$java$lang$String;
            if (v2 == null) {
                v2 = XWorkConverter.class$java$lang$String = new String[0].getClass().getComponentType();
            }
            if (v1.equals(v2)) ** GOTO lbl-1000
            v3 = value.getClass();
            v4 = XWorkConverter.array$Ljava$lang$String;
            if (v4 == null) {
                v4 = XWorkConverter.array$Ljava$lang$String = new String[0].getClass();
            }
            if (!v3.equals(v4)) {
                tc = this.lookup(value.getClass());
            } else lbl-1000:
            // 3 sources

            {
                tc = this.lookup(toClass);
            }
            if (XWorkConverter.LOG.isDebugEnabled()) {
                XWorkConverter.LOG.debug((Object)new StringBuffer().append("global-level type converter for property [").append(property).append("] = ").append((Object)(tc == null ? "none found" : tc)).toString());
            }
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                if (XWorkConverter.LOG.isDebugEnabled()) {
                    XWorkConverter.LOG.debug((Object)new StringBuffer().append("falling back to default type converter [").append(this.defaultTypeConverter).append("]").toString());
                }
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        try {
            if (XWorkConverter.LOG.isDebugEnabled()) {
                XWorkConverter.LOG.debug((Object)"falling back to Ognl's default type conversion");
            }
            return super.convertValue(context, target, member, property, value, toClass);
        }
        catch (Exception e) {
            this.handleConversionException(context, property, value, target);
            return OgnlRuntime.NoConversionPossible;
        }
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className)) {
            return null;
        }
        TypeConverter result = this.defaultMappings.get(className);
        if (result == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("Property: ").append(property).toString());
            LOG.debug((Object)new StringBuffer().append("Class: ").append(clazz.getName()).toString());
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (property != null && !this.noMapping.contains(clazz)) {
                try {
                    Map<String, Object> mapping = this.mappings.get(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    Object converter = mapping.get(property);
                    if (LOG.isDebugEnabled() && converter == null) {
                        LOG.debug((Object)new StringBuffer().append("converter is null for property ").append(property).append(". Mapping size: ").append(mapping.size()).toString());
                        for (String next : mapping.keySet()) {
                            LOG.debug((Object)new StringBuffer().append(next).append(":").append(mapping.get(next)).toString());
                        }
                    }
                    return converter;
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz);
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map context, String property, Object value, Object object) {
        if (Boolean.TRUE.equals(context.get(REPORT_CONVERSION_ERRORS))) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork2.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork2.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    public synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
    }

    public synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    private Object[] getClassProperty(Map context) {
        return (Object[])context.get("__link");
    }

    private Object acceptableErrorValue(Class toClass) {
        if (!toClass.isPrimitive()) {
            return null;
        }
        if (toClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (toClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (toClass == Long.TYPE) {
            return new Long(0L);
        }
        if (toClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toClass == Short.TYPE) {
            return new Short(0);
        }
        if (toClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (toClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    void addConverterMapping(Map<String, Object> mapping, Class clazz) {
        try {
            String converterFilename = XWorkConverter.buildConverterFilename(clazz);
            InputStream is = FileManager.loadFile(converterFilename, clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("processing conversion file [").append(converterFilename).append("] [class=").append(clazz).append("]").toString());
                }
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> it = prop.entrySet().iterator();
                while (it.hasNext() && !mapping.containsKey(key = (String)(entry = it.next()).getKey())) {
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append("[treated as String]").toString());
                        }
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith(CONVERSION_COLLECTION_PREFIX))) {
                        TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append("[treated as TypeConverter ").append(_typeConverter).append("]").toString());
                        }
                        mapping.put(key, _typeConverter);
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<?> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        Class<?> clazz2 = class$ognl$TypeConverter;
                        if (clazz2 == null) {
                            clazz2 = new TypeConverter[0].getClass().getComponentType();
                        }
                        if (converterClass.isAssignableFrom(clazz2)) {
                            TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append("[treated as TypeConverter ").append(_typeConverter).append("]").toString());
                            }
                            mapping.put(key, _typeConverter);
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append("[treated as Class ").append(converterClass).append("]").toString());
                        }
                        mapping.put(key, converterClass);
                        continue;
                    }
                    Class<?> _c = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append("[treated as Class ").append(_c).append("]").toString());
                    }
                    mapping.put(key, _c);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)new StringBuffer().append("Problem loading properties for ").append(clazz.getName()).toString(), (Throwable)ex);
        }
    }

    private Map<String, Object> buildConverterMapping(Class clazz) throws Exception {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Class curClazz = clazz;
        while (true) {
            Class<?> clazz2;
            if ((clazz2 = class$java$lang$Object) == null) {
                clazz2 = new Object[0].getClass().getComponentType();
            }
            if (curClazz.equals(clazz2)) break;
            this.addConverterMapping(mapping, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int x = 0; x < interfaces.length; ++x) {
                this.addConverterMapping(mapping, interfaces[x]);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.mappings.put(clazz, mapping);
        } else {
            this.noMapping.add(clazz);
        }
        return mapping;
    }

    private Map<String, Object> conditionalReload(Class clazz, Map<String, Object> oldValues) throws Exception {
        Map<String, Object> mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading(XWorkConverter.buildConverterFilename(clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    TypeConverter createTypeConverter(String className) throws Exception {
        return (TypeConverter)ObjectFactory.getObjectFactory().buildBean(className, null);
    }

    public void loadConversionProperties(String propsName) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsName);
        Properties props = new Properties();
        props.load(is);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuffer().append("processing conversion file [").append(propsName).append("]").toString());
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            try {
                TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("\t").append(key).append(":").append(entry.getValue()).append(" [treated as TypeConverter ").append(_typeConverter).append("]").toString());
                }
                this.defaultMappings.put(key, _typeConverter);
            }
            catch (Exception e) {
                LOG.error((Object)"Conversion registration error", (Throwable)e);
            }
        }
    }

    TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = this.defaultMappings.get(clazz.getName())) == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!this.defaultMappings.containsKey(interfaces[i].getName())) continue;
                result = this.defaultMappings.get(interfaces[i].getName());
                break;
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }

    public ObjectTypeDeterminer getObjectTypeDeterminer() {
        return this.objectTypeDeterminer;
    }

    public void setObjectTypeDeterminer(ObjectTypeDeterminer determiner) {
        this.objectTypeDeterminer = determiner;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$util$XWorkConverter;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$XWorkConverter = new XWorkConverter[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

