/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.XWorkConverter;
import com.opensymphony.xwork2.util.XWorkList;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ognl.DefaultTypeConverter;
import ognl.Ognl;
import ognl.TypeConverter;

public class XWorkBasicConverter
extends DefaultTypeConverter {
    private static String MILLISECOND_FORMAT = ".SSS";
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$Collection;

    public Object convertValue(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        if (value == null || toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        if (toType == clazz) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(value);
        } else {
            Class<?> clazz2 = class$java$lang$Boolean;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
            }
            if (toType == clazz2) {
                result = this.doConvertToBoolean(value);
            } else if (toType.isArray()) {
                result = this.doConvertToArray(context, o, member, s, value, toType);
            } else {
                Class<?> clazz3 = class$java$util$Date;
                if (clazz3 == null) {
                    clazz3 = class$java$util$Date = new Date[0].getClass().getComponentType();
                }
                if (clazz3.isAssignableFrom(toType)) {
                    result = this.doConvertToDate(context, value, toType);
                } else {
                    Class<?> clazz4 = class$java$util$Collection;
                    if (clazz4 == null) {
                        clazz4 = class$java$util$Collection = new Collection[0].getClass().getComponentType();
                    }
                    if (clazz4.isAssignableFrom(toType)) {
                        result = this.doConvertToCollection(context, o, member, s, value, toType);
                    } else {
                        Class<?> clazz5 = class$java$lang$Character;
                        if (clazz5 == null) {
                            clazz5 = class$java$lang$Character = new Character[0].getClass().getComponentType();
                        }
                        if (toType == clazz5) {
                            result = this.doConvertToCharacter(value);
                        } else if (toType == Character.TYPE) {
                            result = this.doConvertToCharacter(value);
                        } else {
                            Class<?> clazz6 = class$java$lang$Number;
                            if (clazz6 == null) {
                                clazz6 = class$java$lang$Number = new Number[0].getClass().getComponentType();
                            }
                            if (clazz6.isAssignableFrom(toType)) {
                                result = this.doConvertToNumber(context, value, toType);
                            } else {
                                Class<?> clazz7 = class$java$lang$Class;
                                if (clazz7 == null) {
                                    clazz7 = class$java$lang$Class = new Class[0].getClass().getComponentType();
                                }
                                if (toType == clazz7) {
                                    result = this.doConvertToClass(value);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length >= 1) {
                    value = array[0];
                }
                result = this.convertValue(context, o, member, s, value, toType);
            } else if (!"".equals(value)) {
                result = super.convertValue(context, value, toType);
            }
            if (result == null && value != null && !"".equals(value)) {
                throw new XWorkException("Cannot create type " + toType + " from value " + value);
            }
        }
        return result;
    }

    private Locale getLocale(Map context) {
        if (context == null) {
            return Locale.getDefault();
        }
        Locale locale = (Locale)context.get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Collection createCollection(Object fromObject, String propertyName, Class toType, Class memberType, int size) {
        AbstractCollection result;
        Class<?> clazz = class$java$util$Set;
        if (clazz == null) {
            clazz = class$java$util$Set = new Set[0].getClass().getComponentType();
        }
        if (toType == clazz) {
            result = size > 0 ? new HashSet(size) : new HashSet();
        } else {
            Class<?> clazz2 = class$java$util$SortedSet;
            if (clazz2 == null) {
                clazz2 = class$java$util$SortedSet = new SortedSet[0].getClass().getComponentType();
            }
            result = toType == clazz2 ? new TreeSet() : (size > 0 ? new XWorkList(memberType, size) : new XWorkList(memberType));
        }
        return result;
    }

    private Object doConvertToArray(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        Class<?> componentType = toType.getComponentType();
        if (componentType != null) {
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object valueItem = Array.get(value, i);
                    Array.set(result, i, converter.convertValue(context, o, member, s, valueItem, componentType));
                }
            } else {
                result = Array.newInstance(componentType, 1);
                Array.set(result, 0, converter.convertValue(context, o, member, s, value, componentType));
            }
        }
        return result;
    }

    private Object doConvertToCharacter(Object value) {
        if (value instanceof String) {
            String cStr = (String)value;
            return cStr.length() > 0 ? new Character(cStr.charAt(0)) : null;
        }
        return null;
    }

    private Object doConvertToBoolean(Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Object value) {
        Class<?> clazz = null;
        if (value instanceof String && value != null && ((String)value).length() > 0) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XWorkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Collection doConvertToCollection(Map context, Object o, Member member, String prop, Object value, Class toType) {
        Collection result;
        Class clazz;
        Class memberType;
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = memberType = (class$java$lang$String = new String[0].getClass().getComponentType());
        }
        if (o != null && (memberType = XWorkConverter.getInstance().getObjectTypeDeterminer().getElementClass(o.getClass(), prop, null)) == null && (clazz = class$java$lang$String) == null) {
            clazz = memberType = (class$java$lang$String = new String[0].getClass().getComponentType());
        }
        if (toType.isAssignableFrom(value.getClass())) {
            result = (Collection)value;
        } else if (value.getClass().isArray()) {
            Object[] objArray = (Object[])value;
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            result = this.createCollection(o, prop, toType, memberType, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                result.add(converter.convertValue(context, o, member, prop, objArray[i], memberType));
            }
        } else {
            Class<?> clazz3 = class$java$util$Collection;
            if (clazz3 == null) {
                clazz3 = class$java$util$Collection = new Collection[0].getClass().getComponentType();
            }
            if (clazz3.isAssignableFrom(value.getClass())) {
                Collection col = (Collection)value;
                TypeConverter converter = Ognl.getTypeConverter((Map)context);
                result = this.createCollection(o, prop, toType, memberType, col.size());
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    result.add(converter.convertValue(context, o, member, prop, it.next(), memberType));
                }
            } else {
                result = this.createCollection(o, prop, toType, memberType, -1);
                result.add(value);
            }
        }
        return result;
    }

    private Object doConvertToDate(Map context, Object value, Class toType) {
        Date result;
        block25: {
            result = null;
            if (value instanceof String && value != null && ((String)value).length() > 0) {
                String sa = (String)value;
                Locale locale = this.getLocale(context);
                DateFormat df = null;
                Class<?> clazz = class$java$sql$Time;
                if (clazz == null) {
                    clazz = class$java$sql$Time = new Time[0].getClass().getComponentType();
                }
                if (clazz == toType) {
                    df = DateFormat.getTimeInstance(2, locale);
                } else {
                    Date check;
                    Class<?> clazz2 = class$java$sql$Timestamp;
                    if (clazz2 == null) {
                        clazz2 = class$java$sql$Timestamp = new Timestamp[0].getClass().getComponentType();
                    }
                    if (clazz2 == toType) {
                        check = null;
                        SimpleDateFormat dtfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
                        SimpleDateFormat fullfmt = new SimpleDateFormat(dtfmt.toPattern() + MILLISECOND_FORMAT, locale);
                        SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
                        SimpleDateFormat[] fmts = new SimpleDateFormat[]{fullfmt, dtfmt, dfmt};
                        for (int i = 0; i < fmts.length; ++i) {
                            try {
                                check = fmts[i].parse(sa);
                                df = fmts[i];
                                if (check == null) continue;
                                break;
                            }
                            catch (ParseException ignore) {
                                // empty catch block
                            }
                        }
                    } else {
                        Class<?> clazz3 = class$java$util$Date;
                        if (clazz3 == null) {
                            clazz3 = class$java$util$Date = new Date[0].getClass().getComponentType();
                        }
                        if (clazz3 == toType) {
                            check = null;
                            SimpleDateFormat d1 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 1, locale);
                            SimpleDateFormat d2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
                            SimpleDateFormat d3 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
                            SimpleDateFormat[] dfs = new SimpleDateFormat[]{d1, d2, d3};
                            for (int i = 0; i < dfs.length; ++i) {
                                try {
                                    check = dfs[i].parse(sa);
                                    df = dfs[i];
                                    if (check == null) continue;
                                    break;
                                }
                                catch (ParseException ignore) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (df == null) {
                    df = DateFormat.getDateInstance(3, locale);
                }
                try {
                    df.setLenient(false);
                    result = df.parse(sa);
                    Class<?> clazz4 = class$java$util$Date;
                    if (clazz4 == null) {
                        clazz4 = class$java$util$Date = new Date[0].getClass().getComponentType();
                    }
                    if (clazz4 != toType) {
                        try {
                            Constructor constructor = toType.getConstructor(Long.TYPE);
                            return constructor.newInstance(new Long(result.getTime()));
                        }
                        catch (Exception e) {
                            throw new XWorkException("Couldn't create class " + toType + " using default (long) constructor", e);
                        }
                    }
                    break block25;
                }
                catch (ParseException e) {
                    throw new XWorkException("Could not parse date", e);
                }
            }
            Class<?> clazz = class$java$util$Date;
            if (clazz == null) {
                clazz = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            if (clazz.isAssignableFrom(value.getClass())) {
                result = (Date)value;
            }
        }
        return result;
    }

    private Object doConvertToNumber(Map context, Object value, Class toType) {
        Object[] objArray;
        if (value instanceof String) {
            Class<?> clazz = class$java$math$BigDecimal;
            if (clazz == null) {
                clazz = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
            }
            if (toType == clazz) {
                return new BigDecimal((String)value);
            }
            Class<?> clazz2 = class$java$math$BigInteger;
            if (clazz2 == null) {
                clazz2 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
            }
            if (toType == clazz2) {
                return new BigInteger((String)value);
            }
            String stringValue = (String)value;
            if (!(toType.isPrimitive() || stringValue != null && stringValue.length() != 0)) {
                return null;
            }
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            ParsePosition parsePos = new ParsePosition(0);
            if (this.isIntegerType(toType)) {
                numFormat.setParseIntegerOnly(true);
            }
            numFormat.setGroupingUsed(true);
            Number number = numFormat.parse(stringValue, parsePos);
            if (parsePos.getIndex() != stringValue.length()) {
                throw new XWorkException("Unparseable number: \"" + stringValue + "\" at position " + parsePos.getIndex());
            }
            value = super.convertValue(context, (Object)number, toType);
        } else if (value instanceof Object[] && (objArray = (Object[])value).length == 1) {
            return this.doConvertToNumber(context, objArray[0], toType);
        }
        return super.convertValue(context, value, toType);
    }

    protected boolean isIntegerType(Class type) {
        block7: {
            block6: {
                if (Double.TYPE == type || Float.TYPE == type) break block6;
                Class<?> clazz = class$java$lang$Double;
                if (clazz == null) {
                    clazz = class$java$lang$Double = new Double[0].getClass().getComponentType();
                }
                if (clazz == type) break block6;
                Class<?> clazz2 = class$java$lang$Float;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Float = new Float[0].getClass().getComponentType();
                }
                if (clazz2 == type || Character.TYPE == type) break block6;
                Class<?> clazz3 = class$java$lang$Character;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Character = new Character[0].getClass().getComponentType();
                }
                if (clazz3 != type) break block7;
            }
            return false;
        }
        return true;
    }

    private String doConvertToString(Map context, Object value) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Integer(x[i]));
            }
            result = TextUtils.join(", ", intArray);
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> intArray = new ArrayList<Long>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Long(x[i]));
            }
            result = TextUtils.join(", ", intArray);
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> intArray = new ArrayList<Double>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Double(x[i]));
            }
            result = TextUtils.join(", ", intArray);
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> intArray = new ArrayList<Boolean>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Boolean(x[i]));
            }
            result = TextUtils.join(", ", intArray);
        } else if (value instanceof Date) {
            DateFormat df = null;
            if (value instanceof Time) {
                df = DateFormat.getTimeInstance(2, this.getLocale(context));
            } else if (value instanceof Timestamp) {
                SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, this.getLocale(context));
                df = new SimpleDateFormat(dfmt.toPattern() + MILLISECOND_FORMAT);
            } else {
                df = DateFormat.getDateInstance(3, this.getLocale(context));
            }
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = TextUtils.join(", ", (String[])value);
        }
        return result;
    }
}

