/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.DefaultTextProvider;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.CompoundRootAccessor;
import com.opensymphony.xwork2.util.InstantiatingNullHandler;
import com.opensymphony.xwork2.util.ObjectProxy;
import com.opensymphony.xwork2.util.ObjectProxyPropertyAccessor;
import com.opensymphony.xwork2.util.OgnlContextState;
import com.opensymphony.xwork2.util.OgnlUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.XWorkCollectionPropertyAccessor;
import com.opensymphony.xwork2.util.XWorkConverter;
import com.opensymphony.xwork2.util.XWorkEnumerationAcccessor;
import com.opensymphony.xwork2.util.XWorkIteratorPropertyAccessor;
import com.opensymphony.xwork2.util.XWorkListPropertyAccessor;
import com.opensymphony.xwork2.util.XWorkMapPropertyAccessor;
import com.opensymphony.xwork2.util.XWorkMethodAccessor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlValueStack
implements Serializable,
ValueStack {
    private static final long serialVersionUID = 370737852934925530L;
    private static CompoundRootAccessor accessor;
    private static Log LOG;
    private static boolean devMode;
    CompoundRoot root;
    transient Map context;
    Class defaultType;
    Map overrides;
    private static final String MAP_IDENTIFIER_KEY = "com.opensymphony.xwork2.util.OgnlValueStack.MAP_IDENTIFIER_KEY";
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$OgnlValueStack;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$ObjectProxy;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$CompoundRoot;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;

    public static void reset() {
        accessor = new CompoundRootAccessor();
        Class<?> clazz = class$com$opensymphony$xwork2$util$CompoundRoot;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$CompoundRoot = new CompoundRoot[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz, (PropertyAccessor)accessor);
        Class<?> clazz2 = class$java$lang$Object;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz2, (PropertyAccessor)new ObjectAccessor());
        Class<?> clazz3 = class$java$util$Iterator;
        if (clazz3 == null) {
            clazz3 = class$java$util$Iterator = new Iterator[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz3, (PropertyAccessor)new XWorkIteratorPropertyAccessor());
        Class<?> clazz4 = class$java$util$Enumeration;
        if (clazz4 == null) {
            clazz4 = class$java$util$Enumeration = new Enumeration[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz4, (PropertyAccessor)new XWorkEnumerationAcccessor());
        Class<?> clazz5 = class$java$util$List;
        if (clazz5 == null) {
            clazz5 = class$java$util$List = new List[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz5, (PropertyAccessor)new XWorkListPropertyAccessor());
        Class<?> clazz6 = class$java$util$Map;
        if (clazz6 == null) {
            clazz6 = class$java$util$Map = new Map[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz6, (PropertyAccessor)new XWorkMapPropertyAccessor());
        Class<?> clazz7 = class$java$util$Collection;
        if (clazz7 == null) {
            clazz7 = class$java$util$Collection = new Collection[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz7, (PropertyAccessor)new XWorkCollectionPropertyAccessor());
        Class<?> clazz8 = class$java$util$Set;
        if (clazz8 == null) {
            clazz8 = class$java$util$Set = new Set[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz8, (PropertyAccessor)new XWorkCollectionPropertyAccessor());
        Class<?> clazz9 = class$com$opensymphony$xwork2$util$ObjectProxy;
        if (clazz9 == null) {
            clazz9 = class$com$opensymphony$xwork2$util$ObjectProxy = new ObjectProxy[0].getClass().getComponentType();
        }
        OgnlRuntime.setPropertyAccessor((Class)clazz9, (PropertyAccessor)new ObjectProxyPropertyAccessor());
        Class<?> clazz10 = class$java$lang$Object;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OgnlRuntime.setMethodAccessor((Class)clazz10, (MethodAccessor)new XWorkMethodAccessor());
        Class<?> clazz11 = class$com$opensymphony$xwork2$util$CompoundRoot;
        if (clazz11 == null) {
            clazz11 = class$com$opensymphony$xwork2$util$CompoundRoot = new CompoundRoot[0].getClass().getComponentType();
        }
        OgnlRuntime.setMethodAccessor((Class)clazz11, (MethodAccessor)accessor);
        Class<?> clazz12 = class$java$lang$Object;
        if (clazz12 == null) {
            clazz12 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OgnlRuntime.setNullHandler((Class)clazz12, (NullHandler)new InstantiatingNullHandler());
    }

    public static void link(Map context, Class clazz, String name) {
        context.put("__link", new Object[]{clazz, name});
    }

    public OgnlValueStack() {
        this.setRoot(new CompoundRoot());
        this.push(DefaultTextProvider.INSTANCE);
    }

    public OgnlValueStack(ValueStack vs) {
        this.setRoot(new CompoundRoot(vs.getRoot()));
    }

    public static CompoundRootAccessor getAccessor() {
        return accessor;
    }

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    public Map getContext() {
        return this.context;
    }

    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    public void setExprOverrides(Map overrides) {
        if (this.overrides == null) {
            this.overrides = overrides;
        } else {
            this.overrides.putAll(overrides);
        }
    }

    public Map getExprOverrides() {
        return this.overrides;
    }

    public CompoundRoot getRoot() {
        return this.root;
    }

    public void setValue(String expr, Object value) {
        this.setValue(expr, value, devMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        Map context = this.getContext();
        try {
            context.put("conversion.property.fullName", expr);
            context.put("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp", throwExceptionOnFailure ? Boolean.TRUE : Boolean.FALSE);
            OgnlUtil.setValue(expr, context, this.root, value);
        }
        catch (OgnlException e) {
            if (throwExceptionOnFailure) {
                String msg = "Error setting expression '" + expr + "' with value '" + value + "'";
                throw new XWorkException(msg, e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error setting value", (Throwable)e);
            }
        }
        catch (RuntimeException re) {
            if (throwExceptionOnFailure) {
                String msg = "Error setting expression '" + expr + "' with value '" + value + "'";
                throw new XWorkException(msg, re);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error setting value", (Throwable)re);
            }
        }
        finally {
            OgnlContextState.clear(context);
            context.remove("conversion.property.fullName");
            context.remove("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
        }
    }

    public String findString(String expr) {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return (String)this.findValue(expr, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr) {
        try {
            if (expr == null) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if (this.defaultType != null) {
                Object object = this.findValue(expr, this.defaultType);
                return object;
            }
            Object value = OgnlUtil.getValue(expr, this.context, this.root);
            if (value != null) {
                Object object = value;
                return object;
            }
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            OgnlContextState.clear(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findValue(String expr, Class asType) {
        try {
            Object value;
            if (expr == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if ((value = OgnlUtil.getValue(expr, this.context, this.root, asType)) != null) {
                Object object = value;
                return object;
            }
            Object object = this.findInContext(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.findInContext(expr);
            return object;
        }
        catch (Exception e) {
            this.logLookupFailure(expr, e);
            Object object = this.findInContext(expr);
            return object;
        }
        finally {
            OgnlContextState.clear(this.context);
        }
    }

    private Object findInContext(String name) {
        return this.getContext().get(name);
    }

    private void logLookupFailure(String expr, Exception e) {
        StringBuffer msg = new StringBuffer();
        msg.append("Caught an exception while evaluating expression '").append(expr).append("' against value stack");
        if (devMode && LOG.isWarnEnabled()) {
            LOG.warn((Object)msg, (Throwable)e);
            LOG.warn((Object)"NOTE: Previous warning message was issued due to devMode set to true.");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)msg, (Throwable)e);
        }
    }

    public Object peek() {
        return this.root.peek();
    }

    public Object pop() {
        return this.root.pop();
    }

    public void push(Object o) {
        this.root.push(o);
    }

    public void set(String key, Object o) {
        Map<String, Object> setMap = null;
        Object topObj = this.peek();
        if (topObj instanceof Map && ((Map)topObj).get(MAP_IDENTIFIER_KEY) != null) {
            setMap = (Map)topObj;
        } else {
            setMap = new HashMap<String, String>();
            setMap.put(MAP_IDENTIFIER_KEY, "");
            this.push(setMap);
        }
        setMap.put(key, o);
    }

    public int size() {
        return this.root.size();
    }

    private void setRoot(CompoundRoot compoundRoot) {
        this.root = compoundRoot;
        this.context = Ognl.createDefaultContext((Object)this.root, (ClassResolver)accessor, (TypeConverter)XWorkConverter.getInstance());
        this.context.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", this);
        Ognl.setClassResolver((Map)this.context, (ClassResolver)accessor);
        ((OgnlContext)this.context).setTraceEvaluations(false);
        ((OgnlContext)this.context).setKeepLastEvaluation(false);
    }

    private Object readResolve() {
        OgnlValueStack aStack = new OgnlValueStack();
        aStack.setRoot(this.root);
        return aStack;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$util$OgnlValueStack;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$OgnlValueStack = new OgnlValueStack[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        OgnlValueStack.reset();
    }

    public static class ObjectAccessor
    extends ObjectPropertyAccessor {
        public Object getProperty(Map map, Object o, Object o1) throws OgnlException {
            Object obj = super.getProperty(map, o, o1);
            OgnlValueStack.link(map, o.getClass(), (String)o1);
            map.put("last.bean.accessed", o.getClass());
            map.put("last.property.accessed", o1.toString());
            OgnlContextState.updateCurrentPropertyPath(map, o1);
            return obj;
        }

        public void setProperty(Map map, Object o, Object o1, Object o2) throws OgnlException {
            super.setProperty(map, o, o1, o2);
        }
    }
}

