/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.CompoundRoot;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompoundRootAccessor
implements PropertyAccessor,
MethodAccessor,
ClassResolver {
    private static final Log log;
    private static Map invalidMethods;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$CompoundRootAccessor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$NoSuchMethodException;

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        Iterator iterator = root.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o == null) continue;
            try {
                if (OgnlRuntime.hasSetProperty((OgnlContext)ognlContext, o, (Object)name)) {
                    OgnlRuntime.setProperty((OgnlContext)ognlContext, o, (Object)name, (Object)value);
                    return;
                }
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                map.put(name, value);
                return;
            }
            catch (IntrospectionException e) {
            }
        }
        Boolean reportError = (Boolean)context.get("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
        String msg = "No object in the CompoundRoot has a publicly accessible property named '" + name + "' (no setter could be found).";
        if (reportError != null && reportError.booleanValue()) {
            throw new XWorkException(msg);
        }
        log.debug((Object)msg);
    }

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        if (name instanceof Integer) {
            Integer index = (Integer)name;
            return root.cutStack(index);
        }
        if (name instanceof String) {
            if ("top".equals(name)) {
                if (root.size() > 0) {
                    return root.get(0);
                }
                return null;
            }
            Iterator iterator = root.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) continue;
                try {
                    if (!OgnlRuntime.hasGetProperty((OgnlContext)ognlContext, o, (Object)name) && (!(o instanceof Map) || !((Map)o).containsKey(name))) continue;
                    return OgnlRuntime.getProperty((OgnlContext)ognlContext, o, (Object)name);
                }
                catch (OgnlException e) {
                    if (e.getReason() == null) continue;
                    String msg = "Caught an Ognl exception while getting property " + name;
                    throw new XWorkException(msg, e);
                }
                catch (IntrospectionException e) {
                }
            }
            return null;
        }
        return null;
    }

    public Object callMethod(Map context, Object target, String name, Object[] objects) throws MethodFailedException {
        CompoundRoot root = (CompoundRoot)target;
        if ("describe".equals(name)) {
            Object v = objects != null && objects.length == 1 ? objects[0] : root.get(0);
            if (v instanceof Collection || v instanceof Map || v.getClass().isArray()) {
                return v.toString();
            }
            try {
                Map descriptors = OgnlRuntime.getPropertyDescriptors(v.getClass());
                int maxSize = 0;
                Iterator iterator = descriptors.keySet().iterator();
                while (iterator.hasNext()) {
                    String pdName = (String)iterator.next();
                    if (pdName.length() <= maxSize) continue;
                    maxSize = pdName.length();
                }
                TreeSet<String> set = new TreeSet<String>();
                StringBuffer sb = new StringBuffer();
                Iterator<Object> iterator2 = descriptors.values().iterator();
                while (iterator2.hasNext()) {
                    PropertyDescriptor pd = (PropertyDescriptor)iterator2.next();
                    sb.append(pd.getName()).append(": ");
                    int padding = maxSize - pd.getName().length();
                    for (int i = 0; i < padding; ++i) {
                        sb.append(" ");
                    }
                    sb.append(pd.getPropertyType().getName());
                    set.add(sb.toString());
                    sb = new StringBuffer();
                }
                sb = new StringBuffer();
                iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String s = (String)iterator2.next();
                    sb.append(s).append("\n");
                }
                return sb.toString();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            catch (OgnlException e) {
                e.printStackTrace();
            }
            return null;
        }
        Iterator iterator = root.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            Class[] argTypes = this.getArgTypes(objects);
            MethodCall mc = null;
            if (argTypes != null) {
                mc = new MethodCall(clazz, name, argTypes);
            }
            if (argTypes != null && invalidMethods.containsKey(mc)) continue;
            try {
                Object value = OgnlRuntime.callMethod((OgnlContext)((OgnlContext)context), o, (String)name, (String)name, (Object[])objects);
                if (value == null) continue;
                return value;
            }
            catch (OgnlException e) {
                Throwable reason = e.getReason();
                if (mc != null && reason != null) {
                    Class<?> clazz2 = reason.getClass();
                    Class<?> clazz3 = class$java$lang$NoSuchMethodException;
                    if (clazz3 == null) {
                        clazz3 = new NoSuchMethodException[0].getClass().getComponentType();
                    }
                    if (clazz2 == clazz3) {
                        invalidMethods.put(mc, Boolean.TRUE);
                        continue;
                    }
                }
                if (reason == null) continue;
                throw new MethodFailedException(o, name, e.getReason());
            }
        }
        return null;
    }

    public Object callStaticMethod(Map transientVars, Class aClass, String s, Object[] objects) throws MethodFailedException {
        return null;
    }

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        Object root = Ognl.getRoot((Map)context);
        try {
            if (root instanceof CompoundRoot && className.startsWith("vs")) {
                CompoundRoot compoundRoot = (CompoundRoot)root;
                if (className.equals("vs")) {
                    return compoundRoot.peek().getClass();
                }
                int index = Integer.parseInt(className.substring(2));
                return compoundRoot.get(index - 1).getClass();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    private Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> clazz;
            Object arg = args[i];
            if (arg != null) {
                clazz = arg.getClass();
            } else {
                clazz = class$java$lang$Object;
                if (clazz == null) {
                    clazz = new Object[0].getClass().getComponentType();
                }
            }
            classes[i] = clazz;
        }
        return classes;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$util$CompoundRootAccessor;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$CompoundRootAccessor = new CompoundRootAccessor[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
        invalidMethods = new HashMap();
    }

    static class MethodCall {
        Class clazz;
        String name;
        Class[] args;
        int hash;

        public MethodCall(Class clazz, String name, Class[] args) {
            this.clazz = clazz;
            this.name = name;
            this.args = args;
            this.hash = clazz.hashCode() + name.hashCode();
            for (int i = 0; i < args.length; ++i) {
                Class arg = args[i];
                this.hash += arg.hashCode();
            }
        }

        public boolean equals(Object obj) {
            MethodCall mc = (MethodCall)obj;
            return mc.clazz.equals(this.clazz) && mc.name.equals(this.name) && Arrays.equals(mc.args, this.args);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

