/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.reflect._Field;
import net.sf.retrotranslator.runtime.java.lang.reflect._Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static final Pattern SETTER_PATTERN = Pattern.compile("set([A-Z][A-Za-z0-9]*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is|has)([A-Z][A-Za-z0-9]*)$");
    static /* synthetic */ Class class$java$lang$Object;

    public static void addAllFields(Class annotationClass, Class clazz, List<Field> allFields) {
        Field[] fields;
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Annotation_ ann = _Field.getAnnotation((Field)field, (Class)annotationClass);
            if (ann == null) continue;
            allFields.add(field);
        }
        AnnotationUtils.addAllFields(annotationClass, clazz.getSuperclass(), allFields);
    }

    public static void addAllMethods(Class annotationClass, Class clazz, List<Method> allMethods) {
        Method[] methods;
        if (clazz == null) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Annotation_ ann = _Method.getAnnotation((Method)method, (Class)annotationClass);
            if (ann == null) continue;
            allMethods.add(method);
        }
        AnnotationUtils.addAllMethods(annotationClass, clazz.getSuperclass(), allMethods);
    }

    public static void addAllInterfaces(Class clazz, List allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        AnnotationUtils.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    public static List<Method> findAnnotatedMethods(Class clazz, Class<? extends Annotation_> annotationClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        AnnotationUtils.findRecursively(clazz, annotationClass, methods);
        return methods;
    }

    public static void findRecursively(Class clazz, Class<? extends Annotation_> annotationClass, List<Method> methods) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (_Method.getAnnotation((Method)m, annotationClass) == null) continue;
            methods.add(0, m);
        }
        Class clazz2 = clazz.getSuperclass();
        Class<?> clazz3 = class$java$lang$Object;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        if (clazz2 != clazz3) {
            AnnotationUtils.findRecursively(clazz.getSuperclass(), annotationClass, methods);
        }
    }

    public static String resolvePropertyName(Method method) {
        Matcher matcher = SETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 1) {
            String raw = matcher.group(1);
            return new StringBuffer().append(raw.substring(0, 1).toLowerCase()).append(raw.substring(1)).toString();
        }
        matcher = GETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 0) {
            String raw = matcher.group(2);
            return new StringBuffer().append(raw.substring(0, 1).toLowerCase()).append(raw.substring(1)).toString();
        }
        return null;
    }

    public static String[] find(Class clazz, String pckgname) {
        URL url;
        File directory;
        ArrayList<String> classes = new ArrayList<String>();
        String name = new String(pckgname);
        if (!name.startsWith("/")) {
            name = new StringBuffer().append("/").append(name).toString();
        }
        if ((directory = new File((url = clazz.getResource(name = name.replace('.', File.separatorChar))).getFile())).exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                classes.add(new StringBuffer().append(pckgname).append(".").append(files[i].substring(0, files[i].length() - 6)).toString());
            }
        }
        return classes.toArray(new String[classes.size()]);
    }
}

