/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.inject.util;

import com.opensymphony.xwork2.inject.util.Function;
import com.opensymphony.xwork2.inject.util.ReferenceMap;
import com.opensymphony.xwork2.inject.util.ReferenceType;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import java.io.IOException;
import java.io.ObjectInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceCache<K, V>
extends ReferenceMap<K, V> {
    private static final long serialVersionUID = 0L;
    transient ConcurrentMap<Object, Future<V>> futures = new ConcurrentHashMap();
    transient ThreadLocal<Future<V>> localFuture = new ThreadLocal();

    public ReferenceCache(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        super(keyReferenceType, valueReferenceType);
    }

    public ReferenceCache() {
        super(ReferenceType.STRONG, ReferenceType.STRONG);
    }

    protected abstract V create(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    V internalCreate(K key) {
        try {
            FutureTask futureTask = new FutureTask((Callable)new CallableCreate(key));
            Object keyReference = this.referenceKey(key);
            Future future = (Future)this.futures.putIfAbsent(keyReference, (Object)futureTask);
            if (future != null) return (V)future.get();
            try {
                if (this.localFuture.get() != null) {
                    throw new IllegalStateException("Nested creations within the same cache are not allowed.");
                }
                this.localFuture.set((Future<V>)futureTask);
                futureTask.run();
                Object value = futureTask.get();
                this.putStrategy().execute(this, keyReference, this.referenceValue(keyReference, value));
                Object object = value;
                return (V)object;
            }
            finally {
                this.localFuture.remove();
                this.futures.remove(keyReference);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (!(cause instanceof Error)) throw new RuntimeException(cause);
            throw (Error)cause;
        }
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        return value == null ? this.internalCreate(key) : value;
    }

    protected void cancel() {
        Future<V> future = this.localFuture.get();
        if (future == null) {
            throw new IllegalStateException("Not in create().");
        }
        future.cancel(false);
    }

    public static <K, V> ReferenceCache<K, V> of(ReferenceType keyReferenceType, ReferenceType valueReferenceType, final Function<? super K, ? extends V> function) {
        ReferenceCache.ensureNotNull(function);
        return new ReferenceCache<K, V>(keyReferenceType, valueReferenceType){
            private static final long serialVersionUID = 0L;

            @Override
            protected V create(K key) {
                return function.apply(key);
            }
        };
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.futures = new ConcurrentHashMap();
        this.localFuture = new ThreadLocal();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallableCreate
    implements Callable<V> {
        K key;

        public CallableCreate(K key) {
            this.key = key;
        }

        public V call() {
            Object value = ReferenceCache.this.internalGet(this.key);
            if (value != null) {
                return value;
            }
            value = ReferenceCache.this.create(this.key);
            if (value == null) {
                throw new NullPointerException(new StringBuffer().append("create(K) returned null for: ").append(this.key).toString());
            }
            return value;
        }
    }
}

