/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.util.FileManager;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    protected static final Log LOG;
    protected Configuration configuration;
    protected Lock providerLock = new ReentrantLock();
    private List<ConfigurationProvider> configurationProviders = new CopyOnWriteArrayList();
    protected String defaultFrameworkBeanName;
    static /* synthetic */ Class class$com$opensymphony$xwork2$config$ConfigurationManager;

    public ConfigurationManager() {
        this("xwork");
    }

    public ConfigurationManager(String name) {
        this.defaultFrameworkBeanName = name;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new DefaultConfiguration(this.defaultFrameworkBeanName));
            try {
                this.configuration.reload(this.getConfigurationProviders());
            }
            catch (ConfigurationException e) {
                this.setConfiguration(null);
                throw e;
            }
        } else {
            this.conditionalReload();
        }
        return this.configuration;
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationProvider> getConfigurationProviders() {
        this.providerLock.lock();
        try {
            if (this.configurationProviders.size() == 0) {
                this.configurationProviders.add(new XmlConfigurationProvider("xwork.xml", true));
            }
            List<ConfigurationProvider> list = this.configurationProviders;
            return list;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationProviders(List<ConfigurationProvider> configurationProviders) {
        this.providerLock.lock();
        try {
            this.configurationProviders = new CopyOnWriteArrayList(configurationProviders);
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void addConfigurationProvider(ConfigurationProvider provider) {
        if (!this.configurationProviders.contains(provider)) {
            this.configurationProviders.add(provider);
        }
    }

    public void clearConfigurationProviders() {
        for (ConfigurationProvider configurationProvider : this.configurationProviders) {
            try {
                configurationProvider.destroy();
            }
            catch (Exception e) {
                LOG.warn((Object)new StringBuffer().append("error while destroying configuration provider [").append(configurationProvider).append("]").toString(), (Throwable)e);
            }
        }
        this.configurationProviders.clear();
    }

    public synchronized void destroyConfiguration() {
        this.clearConfigurationProviders();
        this.setConfigurationProviders((List<ConfigurationProvider>)new CopyOnWriteArrayList());
        if (this.configuration != null) {
            this.configuration.destroy();
        }
        this.configuration = null;
    }

    public synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking ConfigurationProviders for reload.");
            }
            boolean reload = false;
            List<ConfigurationProvider> providers = this.getConfigurationProviders();
            for (ConfigurationProvider provider : providers) {
                if (!provider.needsReload()) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)new StringBuffer().append("Detected configuration provider ").append(provider).append(" needs to be reloaded.  Reloading all providers.").toString());
                }
                reload = true;
                break;
            }
            if (reload) {
                for (ConfigurationProvider configurationProvider : this.configurationProviders) {
                    try {
                        configurationProvider.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)new StringBuffer().append("error while destroying configuration provider [").append(configurationProvider).append("]").toString(), (Throwable)e);
                    }
                }
                this.configuration.reload(providers);
            }
        }
    }

    public synchronized void reload() {
        this.getConfiguration().reload(this.getConfigurationProviders());
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$config$ConfigurationManager;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$config$ConfigurationManager = new ConfigurationManager[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

