/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.OgnlUtil;
import com.opensymphony.xwork2.validator.Validator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectFactory {
    private static final Log LOG;
    private ClassLoader ccl;
    private static ThreadLocal<ObjectFactory> thSelf;
    private Container container;
    static /* synthetic */ Class class$com$opensymphony$xwork2$ObjectFactory;

    @Inject(value="objectFactory.classloader", required=false)
    public void setClassLoader(ClassLoader cl) {
        this.ccl = cl;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject
    public static void setObjectFactory(ObjectFactory factory) {
        thSelf.set(factory);
    }

    public static ObjectFactory getObjectFactory() {
        return thSelf.get();
    }

    public boolean isNoArgConstructorRequired() {
        return true;
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        if (this.ccl != null) {
            return this.ccl.loadClass(className);
        }
        return ClassLoaderUtil.loadClass(className, this.getClass());
    }

    public Object buildAction(String actionName, String namespace, ActionConfig config, Map extraContext) throws Exception {
        return this.buildBean(config.getClassName(), extraContext);
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        return clazz.newInstance();
    }

    protected Object injectInternalBeans(Object obj) {
        if (obj != null && this.container != null) {
            this.container.inject(obj);
        }
        return obj;
    }

    public Object buildBean(String className, Map extraContext) throws Exception {
        return this.buildBean(className, extraContext, true);
    }

    public Object buildBean(String className, Map extraContext, boolean injectInternal) throws Exception {
        Class clazz = this.getClassInstance(className);
        Object obj = this.buildBean(clazz, extraContext);
        if (injectInternal) {
            this.injectInternalBeans(obj);
        }
        return obj;
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map interceptorRefParams) throws ConfigurationException {
        String message;
        Throwable cause;
        String interceptorClassName = interceptorConfig.getClassName();
        Map thisInterceptorClassParams = interceptorConfig.getParams();
        HashMap params = thisInterceptorClassParams == null ? new HashMap() : new HashMap(thisInterceptorClassParams);
        params.putAll(interceptorRefParams);
        try {
            Interceptor interceptor = (Interceptor)this.buildBean(interceptorClassName, null);
            OgnlUtil.setProperties(params, interceptor);
            interceptor.init();
            return interceptor;
        }
        catch (InstantiationException e) {
            cause = e;
            message = "Unable to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (IllegalAccessException e) {
            cause = e;
            message = "IllegalAccessException while attempting to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (ClassCastException e) {
            cause = e;
            message = "Class [" + interceptorClassName + "] does not implement com.opensymphony.xwork2.interceptor.Interceptor";
        }
        catch (Exception e) {
            cause = e;
            message = "Caught Exception while registering Interceptor class " + interceptorClassName;
        }
        catch (NoClassDefFoundError e) {
            cause = e;
            message = "Could not load class " + interceptorClassName + ". Perhaps it exists but certain dependencies are not available?";
        }
        throw new ConfigurationException(message, cause, interceptorConfig);
    }

    public Result buildResult(ResultConfig resultConfig, Map extraContext) throws Exception {
        String resultClassName = resultConfig.getClassName();
        Result result = null;
        if (resultClassName != null) {
            result = (Result)this.buildBean(resultClassName, extraContext);
            OgnlUtil.setProperties(resultConfig.getParams(), (Object)result, extraContext);
        }
        return result;
    }

    public Validator buildValidator(String className, Map params, Map extraContext) throws Exception {
        Validator validator = (Validator)this.buildBean(className, null);
        OgnlUtil.setProperties(params, validator);
        return validator;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$ObjectFactory;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$ObjectFactory = new ObjectFactory[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        thSelf = new ThreadLocal();
    }

    static class ContinuationsClassLoader
    extends ClassLoader {
        ContinuationsClassLoader() {
        }
    }
}

