/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.validator.AbstractActionValidatorManager;
import com.opensymphony.xwork.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionValidatorManager
extends AbstractActionValidatorManager {
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private static final Map validatorCache = Collections.synchronizedMap(new HashMap());
    private static final Map validatorFileCache = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((Class)DefaultActionValidatorManager.class);

    public synchronized List getValidators(Class clazz, String context) {
        String validatorKey = this.buildValidatorKey(clazz, context);
        if (validatorCache.containsKey(validatorKey)) {
            if (FileManager.isReloadingConfigs()) {
                validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, true, null));
            }
        } else {
            validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, false, null));
        }
        List cfgs = (List)validatorCache.get(validatorKey);
        return this.buildValidatorsFromValidatorConfig(cfgs);
    }

    private List buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List buildValidatorConfigs(Class clazz, String context, boolean checkFile, Set checked) {
        int x;
        Class<?>[] interfaces;
        ArrayList validatorConfigs = new ArrayList();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return validatorConfigs;
        }
        if (clazz.isInterface()) {
            interfaces = clazz.getInterfaces();
            for (x = 0; x < interfaces.length; ++x) {
                validatorConfigs.addAll(this.buildValidatorConfigs(interfaces[x], context, checkFile, checked));
            }
        } else if (!clazz.equals(Object.class)) {
            validatorConfigs.addAll(this.buildValidatorConfigs(clazz.getSuperclass(), context, checkFile, checked));
        }
        interfaces = clazz.getInterfaces();
        for (x = 0; x < interfaces.length; ++x) {
            if (checked.contains(interfaces[x].getName())) continue;
            validatorConfigs.addAll(this.buildClassValidatorConfigs(interfaces[x], checkFile));
            if (context != null) {
                validatorConfigs.addAll(this.buildAliasValidatorConfigs(interfaces[x], context, checkFile));
            }
            checked.add(interfaces[x].getName());
        }
        validatorConfigs.addAll(this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            validatorConfigs.addAll(this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return validatorConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadFile(String fileName, Class clazz, boolean checkFile) {
        ArrayList retList = Collections.EMPTY_LIST;
        if (checkFile && FileManager.fileNeedsReloading((String)fileName) || !validatorFileCache.containsKey(fileName)) {
            InputStream is = null;
            try {
                is = FileManager.loadFile((String)fileName, (Class)clazz);
                if (is != null) {
                    retList = new ArrayList(ValidatorFileParser.parseActionValidatorConfigs(is, fileName));
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to close input stream for " + fileName), (Throwable)e);
                    }
                }
            }
            validatorFileCache.put(fileName, retList);
        } else {
            retList = (List)validatorFileCache.get(fileName);
        }
        return retList;
    }
}

