/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.InterceptorMapping;
import com.opensymphony.xwork.config.impl.DefaultConfiguration;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager {
    protected static final Log LOG = LogFactory.getLog((Class)ConfigurationManager.class);
    protected static Configuration configurationInstance;
    private static List configurationProviders;

    private ConfigurationManager() {
    }

    public static synchronized void setConfiguration(Configuration configuration) {
        configurationInstance = configuration;
    }

    public static synchronized Configuration getConfiguration() {
        if (configurationInstance == null) {
            configurationInstance = new DefaultConfiguration();
            try {
                configurationInstance.reload();
            }
            catch (ConfigurationException e) {
                configurationInstance = null;
                throw e;
            }
        } else {
            ConfigurationManager.conditionalReload();
        }
        return configurationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            if (configurationProviders.size() == 0) {
                configurationProviders.add(new XmlConfigurationProvider());
            }
            return configurationProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigurationProvider(ConfigurationProvider provider) {
        List list = configurationProviders;
        synchronized (list) {
            if (!configurationProviders.contains(provider)) {
                configurationProviders.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            Iterator iterator = configurationProviders.iterator();
            while (iterator.hasNext()) {
                ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
                provider.destroy();
            }
            configurationProviders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void destroyConfiguration() {
        List list = configurationProviders;
        synchronized (list) {
            ConfigurationManager.clearConfigurationProviders();
            configurationProviders = new ArrayList();
            if (configurationInstance != null) {
                ArrayList<Interceptor> destroyedInterceptors = new ArrayList<Interceptor>();
                Map namespacesMap = configurationInstance.getRuntimeConfiguration().getActionConfigs();
                if (namespacesMap != null) {
                    Iterator i = namespacesMap.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry namespaceMapEntry = i.next();
                        String namespace = (String)namespaceMapEntry.getKey();
                        Map actionConfigsMap = (Map)namespaceMapEntry.getValue();
                        Iterator ii = actionConfigsMap.entrySet().iterator();
                        while (ii.hasNext()) {
                            Map.Entry actionConfigMapEntry = ii.next();
                            String actionName = (String)actionConfigMapEntry.getKey();
                            ActionConfig actionConfig = (ActionConfig)actionConfigMapEntry.getValue();
                            List interceptorMappings = actionConfig.getInterceptors();
                            Iterator iii = interceptorMappings.iterator();
                            while (iii.hasNext()) {
                                Interceptor interceptor;
                                InterceptorMapping interceptorMapping = (InterceptorMapping)iii.next();
                                if (interceptorMapping == null || interceptorMapping.getInterceptor() == null || destroyedInterceptors.contains(interceptor = interceptorMapping.getInterceptor())) continue;
                                destroyedInterceptors.add(interceptor);
                                try {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("destroying interceptor [" + interceptor + "] registered under name [" + interceptorMapping.getName() + "] with namespace [" + namespace + "] in package [" + actionConfig.getPackageName() + "]"));
                                    }
                                    interceptor.destroy();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("an exception occurred while calling destroy() method on interceptor [" + interceptor + "] registered under name [" + interceptorMapping.getName() + "] with namespace [" + namespace + "] in package [" + actionConfig.getPackageName() + "]"));
                                }
                            }
                        }
                    }
                }
                configurationInstance.destroy();
            }
            configurationInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            boolean reload;
            List list = configurationProviders;
            synchronized (list) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Checking ConfigurationProviders for reload.");
                }
                reload = false;
                Iterator iterator = ConfigurationManager.getConfigurationProviders().iterator();
                while (iterator.hasNext()) {
                    ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
                    if (!provider.needsReload()) continue;
                    reload = true;
                    break;
                }
            }
            if (reload) {
                configurationInstance.reload();
            }
        }
    }

    static {
        configurationProviders = new ArrayList();
    }
}

