/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.util.ResourceScanner;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFactory {
    private static Map validators = new HashMap();
    private static Log LOG = LogFactory.getLog((Class)ValidatorFactory.class);

    private ValidatorFactory() {
    }

    public static void reset() {
        validators.clear();
    }

    public static Validator getValidator(ValidatorConfig cfg) {
        Validator validator;
        String className = ValidatorFactory.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = ObjectFactory.getObjectFactory().buildValidator(className, cfg.getParams(), null);
        }
        catch (Exception e) {
            String msg = "There was a problem creating a Validator of type " + className + " : caused by " + e.getMessage();
            throw new XworkException(msg, e, cfg);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setMessageParameters(cfg.getMessageParams());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public static void registerValidator(String name, String className) {
        if (validators.containsKey(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Validator with name [" + name + "] with class [" + validators.get(name) + "], replacing it with [" + className + "]"));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering validator of class " + className + " with name " + name));
        }
        validators.put(name, className);
    }

    public static String lookupRegisteredValidatorType(String name) {
        String className = (String)validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    public static void parseValidators() throws IOException, URISyntaxException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading validator definitions.");
        }
        String resourceName = "com/opensymphony/xwork/validator/validators/default.xml";
        ValidatorFactory.loadValidators(ClassLoaderUtil.getResourceAsStream((String)resourceName, (Class)ValidatorFactory.class), resourceName);
        resourceName = "validators.xml";
        ValidatorFactory.loadValidators(ClassLoaderUtil.getResourceAsStream((String)resourceName, (Class)ValidatorFactory.class), resourceName);
        ResourceScanner resourceScanner = new ResourceScanner(new String[]{""}, ValidatorFactory.class);
        List validatorDefs = resourceScanner.scanForResources(new ResourceScanner.Filter(){

            public boolean accept(URL resource) {
                return resource.getFile().endsWith("-validators.xml");
            }
        });
        Iterator i = validatorDefs.iterator();
        while (i.hasNext()) {
            URL validatorDefUrl = (URL)i.next();
            ValidatorFactory.loadValidators(validatorDefUrl.openStream(), validatorDefUrl.getFile().substring(validatorDefUrl.getFile().lastIndexOf("/") + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadValidators(InputStream is, String resourceName) {
        if (is != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loading validators definition from " + resourceName));
            }
            try {
                ValidatorFileParser.parseValidatorDefinitions(is, resourceName);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        try {
            ValidatorFactory.parseValidators();
        }
        catch (Exception e) {
            throw new XworkException(e);
        }
    }
}

