/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.validator.ActionValidatorManager;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.opensymphony.xwork.validator.ValidatorFactory;
import com.opensymphony.xwork.validator.validators.VisitorFieldValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractActionValidatorManager
implements ActionValidatorManager {
    private static final Log LOG = LogFactory.getLog((Class)AbstractActionValidatorManager.class);

    public void validate(Object object, String context) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object);
        this.validate(object, context, (ValidatorContext)validatorContext);
    }

    public void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        List validators = this.getValidators(object.getClass(), context);
        this.validate(object, validators, validatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object object, List validators, ValidatorContext validatorContext) throws ValidationException {
        TreeSet<String> shortcircuitedFields = null;
        Iterator iterator = validators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            try {
                validator.setValidatorContext(validatorContext);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Running validator: " + validator + " for object " + object));
                }
                FieldValidator fValidator = null;
                String fullFieldName = null;
                if (validator instanceof FieldValidator) {
                    fValidator = (FieldValidator)validator;
                    fullFieldName = new InternalValidatorContextWrapper(fValidator.getValidatorContext()).getFullFieldName(fValidator.getFieldName());
                    if (shortcircuitedFields != null && shortcircuitedFields.contains(fullFieldName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Short-circuited, skipping");
                        continue;
                    }
                }
                if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)validator)).isShortCircuit()) {
                    Collection errCol;
                    Collection actionErrors;
                    ArrayList errs = null;
                    if (fValidator != null) {
                        Collection fieldErrors;
                        if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) != null) {
                            errs = new ArrayList(fieldErrors);
                        }
                    } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                        errs = new ArrayList(actionErrors);
                    }
                    validator.validate(object);
                    if (fValidator != null) {
                        if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) == null || ((Object)errCol).equals(errs)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Short-circuiting on field validation");
                        }
                        if (shortcircuitedFields == null) {
                            shortcircuitedFields = new TreeSet<String>();
                        }
                        shortcircuitedFields.add(fullFieldName);
                        continue;
                    }
                    if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || ((Object)errCol).equals(errs)) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"Short-circuiting");
                    break;
                }
                validator.validate(object);
            }
            finally {
                validator.setValidatorContext(null);
            }
        }
    }

    protected String buildValidatorKey(Class clazz, String context) {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    protected List buildValidatorsFromValidatorConfig(List validatorConfigs) {
        ArrayList<Validator> validators = new ArrayList<Validator>(validatorConfigs.size());
        Iterator iterator = validatorConfigs.iterator();
        while (iterator.hasNext()) {
            ValidatorConfig cfg = (ValidatorConfig)iterator.next();
            Validator validator = ValidatorFactory.getValidator(cfg);
            validator.setValidatorType(cfg.getType());
            validators.add(validator);
        }
        return validators;
    }

    protected class InternalValidatorContextWrapper {
        private ValidatorContext validatorContext = null;

        InternalValidatorContextWrapper(ValidatorContext validatorContext) {
            this.validatorContext = validatorContext;
        }

        public String getFullFieldName(String field) {
            if (this.validatorContext instanceof VisitorFieldValidator.AppendingValidatorContext) {
                VisitorFieldValidator.AppendingValidatorContext appendingValidatorContext = (VisitorFieldValidator.AppendingValidatorContext)this.validatorContext;
                return appendingValidatorContext.getFullFieldNameFromParent(field);
            }
            return this.validatorContext.getFullFieldName(field);
        }
    }
}

