/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.spring;

import com.opensymphony.xwork.spring.SpringObjectFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

public class SpringProxyableObjectFactory
extends SpringObjectFactory {
    private static final Log log = LogFactory.getLog((Class)SpringProxyableObjectFactory.class);
    private List skipBeanNames = new ArrayList();

    public Object buildBean(String beanName, Map extraContext) throws Exception {
        block12: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building bean for name " + beanName));
            }
            if (!this.skipBeanNames.contains(beanName)) {
                ApplicationContext anAppContext = this.getApplicationContext(extraContext);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying the application context... appContext = " + anAppContext + ",\n bean name = " + beanName));
                    }
                    return anAppContext.getBean(beanName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Did not find bean definition for bean named " + beanName + ", creating a new one..."));
                    }
                    if (!(this.autoWiringFactory instanceof BeanDefinitionRegistry)) break block12;
                    try {
                        Class<?> clazz = Class.forName(beanName);
                        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.autoWiringFactory;
                        RootBeanDefinition def = new RootBeanDefinition(clazz, this.autowireStrategy);
                        def.setSingleton(false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registering a new bean definition for class " + beanName));
                        }
                        registry.registerBeanDefinition(beanName, (BeanDefinition)def);
                        try {
                            return anAppContext.getBean(beanName);
                        }
                        catch (NoSuchBeanDefinitionException e2) {
                            log.warn((Object)("Could not register new bean definition for bean " + beanName));
                            this.skipBeanNames.add(beanName);
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        this.skipBeanNames.add(beanName);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning autowired instance created by default ObjectFactory");
        }
        return this.autoWireBean(super.buildBean(beanName, extraContext), this.autoWiringFactory);
    }

    protected ApplicationContext getApplicationContext(Map context) {
        return this.appContext;
    }
}

