/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.FileManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.ConfigurationUtil;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import com.opensymphony.xwork.config.providers.XmlHelper;
import com.opensymphony.xwork.util.DomHelper;
import com.opensymphony.xwork.util.location.Location;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Log LOG = LogFactory.getLog((Class)XmlConfigurationProvider.class);
    private Configuration configuration;
    private Set includedFileNames = new TreeSet();
    private String configFileName = "xwork.xml";

    public XmlConfigurationProvider() {
    }

    public XmlConfigurationProvider(String filename) {
        this.configFileName = filename;
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames.clear();
        try {
            this.loadConfigurationFile(this.configFileName, null);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not load XWork configuration file, failing", (Throwable)e);
            throw new ConfigurationException("Error loading configuration file " + this.configFileName, e);
        }
    }

    public boolean needsReload() {
        boolean needsReload = FileManager.fileNeedsReloading((String)this.configFileName);
        Iterator fileNameIterator = this.includedFileNames.iterator();
        while (!needsReload && fileNameIterator.hasNext()) {
            String fileName = (String)fileNameIterator.next();
            needsReload = FileManager.fileNeedsReloading((String)fileName);
        }
        return needsReload;
    }

    protected InputStream getInputStream(String fileName) {
        return FileManager.loadFile((String)fileName, this.getClass());
    }

    protected void addAction(Element actionElement, PackageConfig packageContext) throws ConfigurationException {
        Map results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        Location location = DomHelper.getLocationObject(actionElement);
        String string = methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        if (!TextUtils.stringSet((String)className)) {
            className = ActionSupport.class.getName();
        }
        if (!this.verifyAction(className, name, location)) {
            return;
        }
        Map actionParams = XmlHelper.getParams(actionElement);
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e, actionElement);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List externalrefs = this.buildExternalRefs(actionElement, packageContext);
        List exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        ActionConfig actionConfig = new ActionConfig(methodName, className, actionParams, results, interceptorList, externalrefs, exceptionMappings, packageContext.getName());
        actionConfig.setLocation(location);
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + (TextUtils.stringSet((String)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig));
        }
    }

    protected boolean verifyAction(String className, String name, Location loc) {
        try {
            Class clazz = ObjectFactory.getObjectFactory().getClassInstance(className);
            if (ObjectFactory.getObjectFactory().isNoArgConstructorRequired()) {
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    LOG.error((Object)("Action class [" + className + "] is not public, skipping action [" + name + "]"));
                    return false;
                }
                clazz.getConstructor(new Class[0]);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Action class [" + className + "] not found, skipping action [" + name + "] at " + loc), (Throwable)e);
            return false;
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Action class [" + className + "] does not have a public no-arg constructor," + " skipping action [" + name + "] at " + loc), (Throwable)e);
            return false;
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex, (Object)loc);
        }
    }

    protected void addParameters(Element parametersElement) throws ConfigurationException {
        NodeList parameterNodeList = parametersElement.getElementsByTagName("parameter");
        for (int a = 0; a < parameterNodeList.getLength(); ++a) {
            Element element = (Element)parameterNodeList.item(a);
            String parameterName = element.getAttribute("name");
            String parameterValue = element.getAttribute("value");
            if (parameterName != null && parameterValue != null && parameterName.trim().length() > 0 && parameterValue.trim().length() > 0) {
                if (this.configuration.getParameter(parameterName) != null && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("parameter name [" + parameterName + "] with value [" + this.configuration.getParameter(parameterName) + "] exists overriding it with value [" + parameterValue + "]"));
                }
                this.configuration.setParameter(parameterName, parameterValue);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)"invalid parameter name value pair, either or both of them are null or empty, they will be ignored");
        }
    }

    protected void addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig newPackage = this.buildPackageContext(packageElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + newPackage));
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        this.configuration.addPackageConfig(newPackage.getName(), newPackage);
    }

    protected void addResultTypes(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Location loc = DomHelper.getLocationObject(resultTypeElement);
            Class clazz = this.verifyResultType(className, loc);
            if (clazz == null) continue;
            String paramName = null;
            try {
                paramName = (String)clazz.getField("DEFAULT_PARAM").get(null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ResultTypeConfig resultType = new ResultTypeConfig(name, className, paramName);
            resultType.setLocation(DomHelper.getLocationObject(resultTypeElement));
            Map params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.setParams(params);
            }
            packageContext.addResultTypeConfig(resultType);
            if (!"true".equals(def)) continue;
            packageContext.setDefaultResultType(name);
        }
    }

    protected Class verifyResultType(String className, Location loc) {
        try {
            return ObjectFactory.getObjectFactory().getClassInstance(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("Result class [" + className + "] doesn't exist (ClassNotFoundException) at " + loc.toString() + ", ignoring"), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.warn((Object)("Result class [" + className + "] doesn't exist (NoClassDefFoundError) at " + loc.toString() + ", ignoring"), (Throwable)e);
        }
        return null;
    }

    protected List buildExternalRefs(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList<ExternalReference> refs = new ArrayList<ExternalReference>();
        NodeList externalRefList = element.getElementsByTagName("external-ref");
        String refValue = null;
        for (int i = 0; i < externalRefList.getLength(); ++i) {
            String requiredTemp;
            Element refElement = (Element)externalRefList.item(i);
            if (!refElement.getParentNode().equals(element) && !refElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String refName = refElement.getAttribute("name");
            if (refElement.getChildNodes().getLength() > 0) {
                refValue = XmlHelper.getContent(refElement);
            }
            boolean required = (requiredTemp = refElement.getAttribute("required")) == null || "".equals(requiredTemp) ? true : Boolean.valueOf(requiredTemp);
            refs.add(new ExternalReference(refName, refValue, required));
        }
        return refs;
    }

    protected List buildInterceptorList(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element) && !interceptorRefElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        String name = TextUtils.noNull((String)packageElement.getAttribute("name"));
        String namespace = TextUtils.noNull((String)packageElement.getAttribute("namespace"));
        ExternalReferenceResolver erResolver = null;
        String externalReferenceResolver = TextUtils.noNull((String)packageElement.getAttribute("externalReferenceResolver"));
        PackageConfig cfg = null;
        if (!"".equals(externalReferenceResolver)) {
            try {
                erResolver = (ExternalReferenceResolver)ObjectFactory.getObjectFactory().buildBean(externalReferenceResolver, null);
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e, packageElement);
            }
            catch (Exception e) {
                String msg = "Could not create External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e, packageElement);
            }
        }
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)parent))) {
            cfg = new PackageConfig(name, namespace, isAbstract, erResolver);
        } else {
            List parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
            if (parents.size() <= 0) {
                LOG.error((Object)("Unable to find parent packages " + parent));
                cfg = new PackageConfig(name, namespace, isAbstract, erResolver);
            } else {
                cfg = new PackageConfig(name, namespace, isAbstract, erResolver, parents);
            }
        }
        if (cfg != null) {
            cfg.setLocation(DomHelper.getLocationObject(packageElement));
        }
        return cfg;
    }

    protected Map buildResults(Element element, PackageConfig packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            LinkedHashMap<String, String> resultParams;
            ResultTypeConfig config;
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element) && !resultElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (!TextUtils.stringSet((String)resultName)) {
                resultName = "success";
            }
            if (!TextUtils.stringSet((String)resultType) && !TextUtils.stringSet((String)(resultType = packageContext.getFullDefaultResultType()))) {
                LOG.error((Object)("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?"));
            }
            if ((config = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(resultType)) == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'", (Object)resultElement);
            }
            String resultClass = config.getClazz();
            if (resultClass == null) {
                LOG.error((Object)("Result type '" + resultType + "' is invalid. Modify your xwork.xml file."));
            }
            if ((resultParams = XmlHelper.getParams(resultElement)).size() == 0 && resultElement.getChildNodes().getLength() >= 1 && resultElement.getChildNodes().item(0).getNodeType() == 3) {
                resultParams = new LinkedHashMap<String, String>();
                String paramName = config.getDefaultResultParam();
                if (paramName != null) {
                    String val = XmlHelper.getContent(resultElement);
                    if (val.length() > 0) {
                        resultParams.put(paramName, val);
                    }
                } else {
                    LOG.warn((Object)("no default parameter defined for result of type " + config.getName()));
                }
            }
            LinkedHashMap params = new LinkedHashMap();
            Map configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            ResultConfig resultConfig = new ResultConfig(resultName, resultClass, params);
            resultConfig.setLocation(DomHelper.getLocationObject(element));
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected List buildExceptionMappings(Element element, PackageConfig packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element) && !ehElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map params = XmlHelper.getParams(ehElement);
            if (!TextUtils.stringSet((String)emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig(emName, exceptionClassName, exceptionResult, params);
            ehConfig.setLocation(DomHelper.getLocationObject(ehElement));
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected void loadDefaultInterceptorRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadGobalExceptionMappings(PackageConfig packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig config = new InterceptorStackConfig(name);
        config.setLocation(DomHelper.getLocationObject(element));
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config;
    }

    protected void loadInterceptorStacks(Element element, PackageConfig context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig(name, className, params);
            config.setLocation(DomHelper.getLocationObject(interceptorElement));
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private void loadConfigurationFile(String fileName, Element includeElement) {
        if (!this.includedFileNames.contains(fileName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading xwork configuration from: " + fileName));
            }
            this.includedFileNames.add(fileName);
            Document doc = null;
            InputStream is = null;
            try {
                is = this.getInputStream(fileName);
                if (is == null) {
                    throw new Exception("Could not open file " + fileName);
                }
                InputSource in = new InputSource(is);
                in.setSystemId(ClassLoaderUtil.getResource((String)fileName, this.getClass()).toString());
                HashMap<String, String> dtdMappings = new HashMap<String, String>();
                dtdMappings.put("-//OpenSymphony Group//XWork 1.1.2//EN", "xwork-1.1.2.dtd");
                dtdMappings.put("-//OpenSymphony Group//XWork 1.1.1//EN", "xwork-1.1.1.dtd");
                dtdMappings.put("-//OpenSymphony Group//XWork 1.1//EN", "xwork-1.1.dtd");
                dtdMappings.put("-//OpenSymphony Group//XWork 1.0//EN", "xwork-1.0.dtd");
                doc = DomHelper.parse(in, dtdMappings);
            }
            catch (XworkException e) {
                if (includeElement != null) {
                    throw new ConfigurationException(e, (Object)includeElement);
                }
                throw new ConfigurationException(e);
            }
            catch (Exception e) {
                String s = "Caught exception while loading file " + fileName;
                LOG.error((Object)s, (Throwable)e);
                throw new ConfigurationException(s, e, includeElement);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to close input stream", (Throwable)e);
                    }
                }
            }
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if (nodeName.equals("package")) {
                    this.addPackage(child);
                    continue;
                }
                if (nodeName.equals("include")) {
                    String includeFileName = child.getAttribute("file");
                    this.loadConfigurationFile(includeFileName, child);
                    continue;
                }
                if (!"parameters".equals(nodeName)) continue;
                this.addParameters(child);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded xwork configuration from: " + fileName));
            }
        }
    }

    private List lookupInterceptorReference(PackageConfig context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map refParams = XmlHelper.getParams(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams);
    }
}

