/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ValidatorSupport
implements Validator,
ShortCircuitableValidator {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected String defaultMessage = "";
    protected String messageKey = null;
    private ValidatorContext validatorContext;
    private boolean shortCircuit;

    @Override
    public void setDefaultMessage(String message) {
        this.defaultMessage = message;
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getMessage(Object object) {
        String message;
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        stack.push(this);
        if (this.messageKey != null) {
            if (this.defaultMessage == null || this.defaultMessage.trim().equals("")) {
                this.defaultMessage = this.messageKey;
            }
            message = this.validatorContext.getText(this.messageKey, this.defaultMessage);
        } else {
            message = this.defaultMessage;
        }
        message = TextParseUtil.translateVariables(message, stack);
        stack.pop();
        if (pop) {
            stack.pop();
        }
        return message;
    }

    @Override
    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public void setShortCircuit(boolean shortcircuit) {
        this.shortCircuit = shortcircuit;
    }

    @Override
    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    @Override
    public void setValidatorContext(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    @Override
    public ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }

    protected Object getFieldValue(String name, Object object) throws ValidationException {
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        Object retVal = stack.findValue(name);
        if (pop) {
            stack.pop();
        }
        return retVal;
    }

    protected void addActionError(Object object) {
        this.validatorContext.addActionError(this.getMessage(object));
    }

    protected void addFieldError(String propertyName, Object object) {
        this.validatorContext.addFieldError(propertyName, this.getMessage(object));
    }
}

