/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;

public class StringLengthFieldValidator
extends FieldValidatorSupport {
    private boolean doTrim = true;
    private int maxLength = -1;
    private int minLength = -1;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setTrim(boolean trim) {
        this.doTrim = trim;
    }

    public boolean getTrim() {
        return this.doTrim;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        String val = (String)this.getFieldValue(fieldName, object);
        if (val == null) {
            this.addFieldError(fieldName, object);
        } else {
            if (this.doTrim) {
                val = val.trim();
            }
            if (this.minLength > -1 && val.length() < this.minLength) {
                this.addFieldError(fieldName, object);
            } else if (this.maxLength > -1 && val.length() > this.maxLength) {
                this.addFieldError(fieldName, object);
            }
        }
    }
}

