/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.TextProviderSupport;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingValidatorContext
implements ValidatorContext {
    private LocaleProvider localeProvider;
    private TextProvider textProvider;
    private ValidationAware validationAware;

    public DelegatingValidatorContext(ValidationAware validationAware, TextProvider textProvider, LocaleProvider localeProvider) {
        this.textProvider = textProvider;
        this.validationAware = validationAware;
        this.localeProvider = localeProvider;
    }

    public DelegatingValidatorContext(Object object) {
        this.localeProvider = DelegatingValidatorContext.makeLocaleProvider(object);
        this.validationAware = DelegatingValidatorContext.makeValidationAware(object);
        this.textProvider = DelegatingValidatorContext.makeTextProvider(object, this.localeProvider);
    }

    public DelegatingValidatorContext(Class clazz) {
        this.localeProvider = new ActionContextLocaleProvider();
        this.textProvider = new TextProviderSupport(clazz, this.localeProvider);
        this.validationAware = new LoggingValidationAware(clazz);
    }

    @Override
    public void setActionErrors(Collection errorMessages) {
        this.validationAware.setActionErrors(errorMessages);
    }

    @Override
    public Collection getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    @Override
    public void setActionMessages(Collection messages) {
        this.validationAware.setActionMessages(messages);
    }

    @Override
    public Collection getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    @Override
    public void setFieldErrors(Map errorMap) {
        this.validationAware.setFieldErrors(errorMap);
    }

    @Override
    public Map getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    @Override
    public String getFullFieldName(String fieldName) {
        return fieldName;
    }

    @Override
    public Locale getLocale() {
        return this.localeProvider.getLocale();
    }

    @Override
    public String getText(String aTextName) {
        return this.textProvider.getText(aTextName);
    }

    @Override
    public String getText(String aTextName, String defaultValue) {
        return this.textProvider.getText(aTextName, defaultValue);
    }

    @Override
    public String getText(String aTextName, List args) {
        return this.textProvider.getText(aTextName, args);
    }

    @Override
    public String getText(String aTextName, String defaultValue, List args) {
        return this.textProvider.getText(aTextName, defaultValue, args);
    }

    @Override
    public ResourceBundle getTexts(String aBundleName) {
        return this.textProvider.getTexts(aBundleName);
    }

    @Override
    public ResourceBundle getTexts() {
        return this.textProvider.getTexts();
    }

    @Override
    public void addActionError(String anErrorMessage) {
        this.validationAware.addActionError(anErrorMessage);
    }

    @Override
    public void addActionMessage(String aMessage) {
        this.validationAware.addActionMessage(aMessage);
    }

    @Override
    public void addFieldError(String fieldName, String errorMessage) {
        this.validationAware.addFieldError(fieldName, errorMessage);
    }

    @Override
    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    @Override
    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    @Override
    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    @Override
    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    public static TextProvider makeTextProvider(Object object, LocaleProvider localeProvider) {
        if (object instanceof TextProvider) {
            return (TextProvider)object;
        }
        return new TextProviderSupport(object.getClass(), localeProvider);
    }

    protected static LocaleProvider makeLocaleProvider(Object object) {
        if (object instanceof LocaleProvider) {
            return (LocaleProvider)object;
        }
        return new ActionContextLocaleProvider();
    }

    protected static ValidationAware makeValidationAware(Object object) {
        if (object instanceof ValidationAware) {
            return (ValidationAware)object;
        }
        return new LoggingValidationAware(object);
    }

    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    protected TextProvider getTextProvider() {
        return this.textProvider;
    }

    protected void setValidationAware(ValidationAware validationAware) {
        this.validationAware = validationAware;
    }

    protected ValidationAware getValidationAware() {
        return this.validationAware;
    }

    private static class LoggingValidationAware
    implements ValidationAware {
        private Log log;

        public LoggingValidationAware(Class clazz) {
            this.log = LogFactory.getLog((Class)clazz);
        }

        public LoggingValidationAware(Object obj) {
            this.log = LogFactory.getLog(obj.getClass());
        }

        @Override
        public void setActionErrors(Collection errorMessages) {
            for (String s : errorMessages) {
                this.addActionError(s);
            }
        }

        @Override
        public Collection getActionErrors() {
            return null;
        }

        @Override
        public void setActionMessages(Collection messages) {
            for (String s : messages) {
                this.addActionMessage(s);
            }
        }

        @Override
        public Collection getActionMessages() {
            return null;
        }

        @Override
        public void setFieldErrors(Map errorMap) {
            for (Map.Entry entry : errorMap.entrySet()) {
                this.addFieldError((String)entry.getKey(), (String)entry.getValue());
            }
        }

        @Override
        public Map getFieldErrors() {
            return null;
        }

        @Override
        public void addActionError(String anErrorMessage) {
            this.log.error((Object)("Validation error: " + anErrorMessage));
        }

        @Override
        public void addActionMessage(String aMessage) {
            this.log.info((Object)("Validation Message: " + aMessage));
        }

        @Override
        public void addFieldError(String fieldName, String errorMessage) {
            this.log.error((Object)("Validation error for " + fieldName + ":" + errorMessage));
        }

        @Override
        public boolean hasActionErrors() {
            return false;
        }

        @Override
        public boolean hasActionMessages() {
            return false;
        }

        @Override
        public boolean hasErrors() {
            return false;
        }

        @Override
        public boolean hasFieldErrors() {
            return false;
        }
    }

    private static class ActionContextLocaleProvider
    implements LocaleProvider {
        private ActionContextLocaleProvider() {
        }

        @Override
        public Locale getLocale() {
            return ActionContext.getContext().getLocale();
        }
    }
}

