/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.util.XWorkConverter;
import com.opensymphony.xwork.util.XWorkList;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ognl.DefaultTypeConverter;
import ognl.Ognl;
import ognl.TypeConverter;

public class XWorkBasicConverter
extends DefaultTypeConverter {
    public Object convertValue(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        if (value.getClass().isAssignableFrom(toType)) {
            return value;
        }
        if (toType == String.class) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(value);
        } else if (toType == Boolean.class) {
            result = this.doConvertToBoolean(value);
        } else if (toType.isArray()) {
            result = this.doConvertToArray(context, o, member, s, value, toType);
        } else if (toType == Date.class) {
            result = this.doConvertToDate(context, value);
        } else if (Collection.class.isAssignableFrom(toType)) {
            result = this.doConvertToCollection(context, o, member, s, value, toType);
        } else if (Number.class.isAssignableFrom(toType)) {
            result = this.doConvertToNumber(context, value, toType);
        } else if (toType == Class.class) {
            result = this.doConvertToClass(value);
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length >= 1) {
                    value = array[0];
                }
                result = this.convertValue(context, o, member, s, value, toType);
            } else {
                result = super.convertValue(context, value, toType);
            }
        }
        return result;
    }

    private Locale getLocale(Map context) {
        Locale locale = (Locale)context.get("com.opensymphony.xwork.ActionContext.locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Collection createCollection(Class toType, Class memberType, int size) {
        AbstractCollection result = toType == Set.class ? (size > 0 ? new HashSet(size) : new HashSet()) : (toType == SortedSet.class ? new TreeSet() : (size > 0 ? new XWorkList(memberType, size) : new XWorkList(memberType)));
        return result;
    }

    private Object doConvertToArray(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        Class<?> componentType = toType.getComponentType();
        if (componentType != null) {
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object valueItem = Array.get(value, i);
                    Array.set(result, i, converter.convertValue(context, o, member, s, valueItem, componentType));
                }
            } else {
                result = Array.newInstance(componentType, 1);
                Array.set(result, 0, converter.convertValue(context, o, member, s, value, componentType));
            }
        }
        return result;
    }

    private Object doConvertToBoolean(Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Object value) {
        Class<?> clazz = null;
        if (value instanceof String) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XworkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Collection doConvertToCollection(Map context, Object o, Member member, String prop, Object value, Class toType) {
        Collection result = null;
        Class<String> memberType = String.class;
        if (o != null && (memberType = (Class<String>)XWorkConverter.getInstance().getConverter(o.getClass(), "Collection_" + prop)) == null) {
            memberType = String.class;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            result = (Collection)value;
        } else if (value.getClass().isArray()) {
            Object[] objArray = (Object[])value;
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            result = this.createCollection(toType, memberType, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                result.add(converter.convertValue(context, o, member, prop, objArray[i], memberType));
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection col = (Collection)value;
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            result = this.createCollection(toType, memberType, col.size());
            Iterator it = col.iterator();
            while (it.hasNext()) {
                result.add(converter.convertValue(context, o, member, prop, it.next(), memberType));
            }
        } else {
            result = this.createCollection(toType, memberType, -1);
            result.add(value);
        }
        return result;
    }

    private Object doConvertToDate(Map context, Object value) {
        Date result = null;
        if (value instanceof String) {
            String sa = (String)value;
            Locale locale = this.getLocale(context);
            DateFormat df = DateFormat.getDateInstance(3, locale);
            try {
                result = df.parse(sa);
            }
            catch (ParseException e) {
                throw new XworkException("Could not parse date", e);
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            result = (Date)value;
        }
        return result;
    }

    private Object doConvertToNumber(Map context, Object value, Class toType) {
        Object[] objArray;
        if (value instanceof String) {
            if (toType == BigDecimal.class) {
                return new BigDecimal((String)value);
            }
            if (toType == BigInteger.class) {
                return new BigInteger((String)value);
            }
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            try {
                value = super.convertValue(context, (Object)numFormat.parse((String)value), toType);
            }
            catch (ParseException parseException) {}
        } else if (value instanceof Object[] && (objArray = (Object[])value).length == 1) {
            return this.doConvertToNumber(context, objArray[0], toType);
        }
        return super.convertValue(context, value, toType);
    }

    private String doConvertToString(Map context, Object value) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Integer(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> intArray = new ArrayList<Long>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Long(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> intArray = new ArrayList<Double>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Double(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> intArray = new ArrayList<Boolean>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Boolean(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof Date) {
            DateFormat df = DateFormat.getDateInstance(3, this.getLocale(context));
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = TextUtils.join((String)", ", (String[])((String[])value));
        }
        return result;
    }
}

