/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.google.common.cache.CacheBuilder;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.util.OgnlUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.SourceVersion;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SafeExpressionUtil {
    private static final Set<String> UNSAFE_VARIABLE_NAMES;
    private static final Set<String> UNSAFE_NODE_TYPES;
    private static final Optional<Method> OGNL_METHOD_GET_METHOD;
    private static final Optional<Field> OGNL_METHOD_GET_CLASS_STATIC_FIELD;
    private static final Log log;
    private final Set<String> SAFE_EXPRESSIONS_CACHE = Collections.newSetFromMap(CacheBuilder.newBuilder().maximumSize(10000L).build().asMap());
    private final Set<String> UNSAFE_EXPRESSIONS_CACHE = Collections.newSetFromMap(CacheBuilder.newBuilder().maximumSize(1000L).build().asMap());
    private final Set<String> unsafePropertyNames = this.getUnsafePropertyNames();
    private final Set<String> unsafePackageNames = this.getUnsafePackageNames();
    private final Set<String> unsafeMethodNames = this.getUnsafeMethodNames();
    private final Set<String> allowedClassNames = this.getAllowedClassNames();

    private Set<String> getUnsafePropertyNames() {
        HashSet<String> set = new HashSet<String>(ConfigurationManager.getConfiguration().getExcludedClasses());
        set.add("class");
        set.add("classLoader");
        return set;
    }

    private Set<String> getUnsafePackageNames() {
        HashSet<String> blockedPackages = new HashSet<String>(ConfigurationManager.getConfiguration().getExcludedPackageNames());
        return Collections.unmodifiableSet(blockedPackages);
    }

    private Set<String> getUnsafeMethodNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("getClass");
        set.add("getClassLoader");
        return Collections.unmodifiableSet(set);
    }

    private Set<String> getAllowedClassNames() {
        HashSet<String> allowedClassNames = new HashSet<String>(ConfigurationManager.getConfiguration().getAllowedClasses());
        return Collections.unmodifiableSet(allowedClassNames);
    }

    public boolean isSafeExpression(String expression) {
        return this.isSafeExpressionInternal(expression, new HashSet<String>());
    }

    private boolean isSafeExpressionInternal(String expression, Set<String> visitedExpressions) {
        if (!this.SAFE_EXPRESSIONS_CACHE.contains(expression)) {
            if (this.UNSAFE_EXPRESSIONS_CACHE.contains(expression)) {
                return false;
            }
            if (this.isUnSafeClass(expression)) {
                this.UNSAFE_EXPRESSIONS_CACHE.add(expression);
                return false;
            }
            if (SourceVersion.isName(this.trimQuotes(expression)) && this.allowedClassNames.contains(this.trimQuotes(expression))) {
                this.SAFE_EXPRESSIONS_CACHE.add(expression);
            } else {
                try {
                    Object parsedExpression = OgnlUtil.compile(expression);
                    if (parsedExpression instanceof Node) {
                        if (this.containsUnsafeExpression((Node)parsedExpression, visitedExpressions)) {
                            this.UNSAFE_EXPRESSIONS_CACHE.add(expression);
                            log.debug((Object)String.format("Unsafe clause found in [\" %s \"]", expression));
                        } else {
                            this.SAFE_EXPRESSIONS_CACHE.add(expression);
                        }
                    }
                }
                catch (RuntimeException | OgnlException ex) {
                    this.SAFE_EXPRESSIONS_CACHE.add(expression);
                    log.debug((Object)"Cannot verify safety of OGNL expression", ex);
                }
            }
        }
        return this.SAFE_EXPRESSIONS_CACHE.contains(expression);
    }

    private boolean containsUnsafeExpression(Node node, Set<String> visitedExpressions) {
        String nodeClassName = node.getClass().getName();
        if (UNSAFE_NODE_TYPES.contains(nodeClassName)) {
            return true;
        }
        if ("ognl.ASTStaticMethod".equals(nodeClassName) && !this.allowedClassNames.contains(SafeExpressionUtil.getClassNameFromStaticMethod(node))) {
            return true;
        }
        if ("ognl.ASTProperty".equals(nodeClassName) && this.isUnSafeClass(node.toString())) {
            return true;
        }
        if ("ognl.ASTMethod".equals(nodeClassName) && this.unsafeMethodNames.contains(SafeExpressionUtil.getMethodInOgnlExp(node))) {
            return true;
        }
        if ("ognl.ASTVarRef".equals(nodeClassName) && UNSAFE_VARIABLE_NAMES.contains(node.toString())) {
            return true;
        }
        if ("ognl.ASTConst".equals(nodeClassName) && !this.isSafeConstantExpressionNode(node, visitedExpressions)) {
            return true;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node childNode = node.jjtGetChild(i);
            if (childNode == null || !this.containsUnsafeExpression(childNode, visitedExpressions)) continue;
            return true;
        }
        return false;
    }

    private boolean isSafeConstantExpressionNode(Node node, Set<String> visitedExpressions) {
        try {
            String value = node.getValue(new OgnlContext(), null).toString();
            if (visitedExpressions.contains(value) || value == null || value.isEmpty()) {
                return true;
            }
            visitedExpressions.add(value);
            return this.isSafeExpressionInternal(value, visitedExpressions);
        }
        catch (OgnlException e) {
            log.debug((Object)"Cannot verify safety of OGNL expression", (Throwable)e);
            return true;
        }
    }

    private static String getClassNameFromStaticMethod(Node node) {
        try {
            if (OGNL_METHOD_GET_CLASS_STATIC_FIELD.isPresent()) {
                return (String)OGNL_METHOD_GET_CLASS_STATIC_FIELD.get().get(node);
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Method can't be accessed for introspection", (Throwable)e);
        }
        return null;
    }

    private static String getMethodInOgnlExp(Node node) {
        try {
            if (OGNL_METHOD_GET_METHOD.isPresent()) {
                return (String)OGNL_METHOD_GET_METHOD.get().invoke((Object)node, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.debug((Object)"Method can't be accessed for introspection", (Throwable)e);
        }
        return null;
    }

    private String trimQuotes(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.startsWith("\"") && trimmedValue.endsWith("\"")) {
            return this.trimQuotes(trimmedValue.substring(1, trimmedValue.length() - 1));
        }
        if (trimmedValue.startsWith("'") && trimmedValue.endsWith("'")) {
            return this.trimQuotes(trimmedValue.substring(1, trimmedValue.length() - 1));
        }
        return value;
    }

    private boolean isUnSafeClass(String expression) {
        String trimmedClassName = this.trimQuotes(expression);
        if (this.unsafePropertyNames.contains(trimmedClassName)) {
            return true;
        }
        if (SourceVersion.isName(trimmedClassName)) {
            List<String> parentPackageNames = this.populateParentPackages(trimmedClassName, new ArrayList<String>());
            return parentPackageNames.stream().anyMatch(this.unsafePackageNames::contains);
        }
        return false;
    }

    private List<String> populateParentPackages(String name, List<String> packages) {
        int dotPos = name.lastIndexOf(46);
        if (dotPos != -1) {
            String packageName = name.substring(0, dotPos);
            packages.add(packageName);
            this.populateParentPackages(packageName, packages);
        }
        return packages;
    }

    static {
        Method method;
        log = LogFactory.getLog(SafeExpressionUtil.class);
        HashSet<String> set = new HashSet<String>();
        set.add("ognl.ASTStaticField");
        set.add("ognl.ASTCtor");
        set.add("ognl.ASTAssign");
        UNSAFE_NODE_TYPES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("#_memberAccess");
        set.add("#context");
        set.add("#request");
        set.add("#parameters");
        set.add("#session");
        set.add("#application");
        set.add("#attr");
        UNSAFE_VARIABLE_NAMES = Collections.unmodifiableSet(set);
        Field getStaticMethodClassName = null;
        try {
            Class<?> astStaticMethodClass = Class.forName("ognl.ASTStaticMethod");
            getStaticMethodClassName = astStaticMethodClass.getDeclaredField("className");
            getStaticMethodClassName.setAccessible(true);
        }
        catch (Exception astStaticMethodClass) {
            // empty catch block
        }
        OGNL_METHOD_GET_CLASS_STATIC_FIELD = Optional.ofNullable(getStaticMethodClassName);
        try {
            Class<?> aClass = Class.forName("ognl.ASTMethod");
            method = aClass.getMethod("getMethodName", new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception e) {
            method = null;
        }
        OGNL_METHOD_GET_METHOD = Optional.ofNullable(method);
    }
}

